/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import org.infinispan.server.core.security.UsernamePasswordAuthenticator;
import org.infinispan.server.memcached.MemcachedInboundAdapter;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedAuthenticationConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.text.TextConstants;
import org.infinispan.server.memcached.text.TextDecoder;
import org.infinispan.server.memcached.text.TextOpDecoderImpl;

public abstract class TextAuthDecoder
extends TextDecoder {
    private final UsernamePasswordAuthenticator authenticator;

    protected TextAuthDecoder(MemcachedServer server) {
        super(server, ANONYMOUS);
        this.authenticator = ((MemcachedAuthenticationConfiguration)((MemcachedServerConfiguration)server.getConfiguration()).authentication()).text().authenticator();
    }

    protected void auth(byte[] token) {
        String s = new String(token, StandardCharsets.US_ASCII);
        String[] parts = s.split(" ");
        if (parts.length != 2) {
            this.authFailure("Wrong credentials");
        } else {
            this.authenticator.authenticate(parts[0], parts[1].toCharArray()).handle((subject, t) -> {
                if (t != null) {
                    this.authFailure(t.getMessage());
                } else {
                    this.ctx.channel().eventLoop().submit(() -> {
                        ByteBuf buf = MemcachedInboundAdapter.getAllocator(this.ctx).acquire(TextConstants.STORED.length);
                        buf.writeBytes(TextConstants.STORED);
                        MemcachedInboundAdapter inbound = (MemcachedInboundAdapter)this.ctx.pipeline().get(MemcachedInboundAdapter.class);
                        TextOpDecoderImpl decoder = new TextOpDecoderImpl(this.server, (Subject)subject);
                        decoder.registerExceptionHandler(inbound::handleExceptionally);
                        this.ctx.pipeline().replace("decoder", "decoder", (ChannelHandler)decoder);
                        inbound.flushBufferIfNeeded(this.ctx);
                    });
                }
                return null;
            });
        }
    }

    private void authFailure(String message) {
        this.ctx.channel().eventLoop().submit(() -> {
            String s = "CLIENT_ERROR authentication failed: " + message;
            ByteBuf buf = MemcachedInboundAdapter.getAllocator(this.ctx).acquire(s.length());
            ByteBufUtil.writeAscii((ByteBuf)buf, (CharSequence)s);
        });
    }
}

