/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public enum RespCommand {
    GET,
    SET,
    INCR,
    DECR,
    DEL,
    MSET,
    MGET,
    PUBLISH,
    PING,
    PSUBSCRIBE,
    PUNSUBSCRIBE,
    SUBSCRIBE,
    UNSUBSCRIBE,
    RESET,
    COMMAND,
    ECHO,
    HELLO,
    AUTH,
    CONFIG,
    INFO,
    READWRITE,
    READONLY,
    SELECT,
    QUIT;

    private final byte[] bytes = this.name().getBytes(StandardCharsets.US_ASCII);
    private static final RespCommand[][] indexedRespCommand;

    public static RespCommand fromByteBuf(ByteBuf buf, int commandLength) {
        byte ignoreCase;
        if (buf.readableBytes() < commandLength + 2) {
            return null;
        }
        int readOffset = buf.readerIndex();
        buf.readerIndex(readOffset + commandLength + 2);
        byte b = buf.getByte(readOffset);
        byte by = ignoreCase = b >= 97 ? (byte)(b - 97) : (byte)(b - 65);
        if (ignoreCase < 0 || ignoreCase > 25) {
            return null;
        }
        RespCommand[] target = indexedRespCommand[ignoreCase];
        if (target == null) {
            return null;
        }
        for (RespCommand possible : target) {
            byte[] possibleBytes = possible.bytes;
            if (commandLength != possibleBytes.length) continue;
            boolean matches = true;
            for (int i = 1; i < possibleBytes.length; ++i) {
                byte upperByte = possibleBytes[i];
                byte targetByte = buf.getByte(readOffset + i);
                if (upperByte == targetByte || upperByte + 22 == targetByte) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return possible;
        }
        return null;
    }

    static {
        indexedRespCommand = new RespCommand[26][];
        RespCommand.indexedRespCommand[0] = new RespCommand[]{AUTH};
        RespCommand.indexedRespCommand[2] = new RespCommand[]{CONFIG, COMMAND};
        RespCommand.indexedRespCommand[3] = new RespCommand[]{DECR, DEL};
        RespCommand.indexedRespCommand[4] = new RespCommand[]{ECHO};
        RespCommand.indexedRespCommand[6] = new RespCommand[]{GET};
        RespCommand.indexedRespCommand[7] = new RespCommand[]{HELLO};
        RespCommand.indexedRespCommand[8] = new RespCommand[]{INCR, INFO};
        RespCommand.indexedRespCommand[12] = new RespCommand[]{MGET, MSET};
        RespCommand.indexedRespCommand[15] = new RespCommand[]{PUBLISH, PING, PSUBSCRIBE, PUNSUBSCRIBE};
        RespCommand.indexedRespCommand[16] = new RespCommand[]{QUIT};
        RespCommand.indexedRespCommand[17] = new RespCommand[]{RESET, READWRITE, READONLY};
        RespCommand.indexedRespCommand[18] = new RespCommand[]{SET, SUBSCRIBE, SELECT};
        RespCommand.indexedRespCommand[20] = new RespCommand[]{UNSUBSCRIBE};
    }
}

