/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.resp.Authenticator;
import org.infinispan.server.resp.configuration.AuthenticationConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;

public class AuthenticationConfigurationBuilder
extends AbstractProtocolServerConfigurationChildBuilder<RespServerConfiguration, AuthenticationConfigurationBuilder>
implements Builder<AuthenticationConfiguration> {
    private final AttributeSet attributes = AuthenticationConfiguration.attributeDefinitionSet();
    private Authenticator authenticator;
    private boolean enabled;

    AuthenticationConfigurationBuilder(ProtocolServerConfigurationBuilder builder) {
        super((ProtocolServerConfigurationChildBuilder)builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public AuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public AuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder securityRealm(String realm) {
        this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).set((Object)realm);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(AuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public AuthenticationConfigurationBuilder authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this.enable();
    }

    public void validate() {
        if (this.enabled && this.authenticator == null) {
            throw RespServerConfigurationBuilder.logger.authenticationWithoutAuthenticator();
        }
    }

    public AuthenticationConfiguration create() {
        return new AuthenticationConfiguration(this.attributes.protect(), this.authenticator, this.enabled);
    }

    public Builder<?> read(AuthenticationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public AuthenticationConfigurationBuilder self() {
        return this;
    }
}

