/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.tx;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.TransactionResp3Command;
import org.infinispan.server.resp.tx.RespTransactionHandler;
import org.infinispan.server.resp.tx.TransactionCommand;
import org.infinispan.util.concurrent.CompletionStages;

public class EXEC
extends RespCommand
implements Resp3Command,
TransactionResp3Command {
    public EXEC() {
        super(1, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        RespErrorUtil.customError("EXEC without MULTI", handler.allocator());
        return handler.myStage();
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(RespTransactionHandler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        Resp3Handler next = handler.respServer().newHandler();
        CompletionStage cs = handler.performingOperations(ctx).thenCompose(commands -> this.perform((List<TransactionCommand>)commands, handler, next, ctx));
        return next.stageToReturn(cs, ctx, ignore -> next);
    }

    private CompletionStage<?> perform(List<TransactionCommand> commands, RespTransactionHandler curr, Resp3Handler next, ChannelHandlerContext ctx) {
        if (curr.hasFailed()) {
            RespErrorUtil.transactionAborted(curr.allocator());
            return CompletableFutures.completedNull();
        }
        if (commands == null) {
            Consumers.GET_BICONSUMER.accept(null, curr.allocator());
            return CompletableFutures.completedNull();
        }
        AdvancedCache<byte[], byte[]> cache = curr.cache();
        boolean batchEnabled = cache.getCacheConfiguration().invocationBatching().enabled();
        if (!batchEnabled) {
            log.multiKeyOperationUseBatching();
        } else {
            cache.startBatch();
        }
        Resp3Handler.writeArrayPrefix(commands.size(), curr.allocator());
        return this.orderlyExecution(next, ctx, commands, 0, CompletableFutures.completedNull()).whenComplete((ignore, t) -> {
            if (batchEnabled) {
                cache.endBatch(true);
            }
        });
    }

    private CompletionStage<?> orderlyExecution(Resp3Handler handler, ChannelHandlerContext ctx, List<TransactionCommand> commands, int index, CompletionStage<?> current) {
        if (index == commands.size()) {
            return current;
        }
        TransactionCommand command = commands.get(index);
        return CompletionStages.handleAndCompose(current, (r, ignore) -> this.orderlyExecution(handler, ctx, commands, index + 1, command.perform(handler, ctx)));
    }
}

