/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import java.util.Iterator;
import java.util.List;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.commands.FamilyCommand;
import org.infinispan.server.resp.commands.cluster.KEYSLOT;
import org.infinispan.server.resp.commands.cluster.NODES;
import org.infinispan.server.resp.commands.cluster.SHARDS;
import org.infinispan.server.resp.commands.cluster.SLOTS;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;
import org.jgroups.stack.IpAddress;

public class CLUSTER
extends FamilyCommand {
    private static final RespCommand[] CLUSTER_COMMANDS = new RespCommand[]{new SHARDS(), new NODES(), new SLOTS(), new KEYSLOT()};

    public CLUSTER() {
        super(-2, 0, 0, 0);
    }

    @Override
    public RespCommand[] getFamilyCommands() {
        return CLUSTER_COMMANDS;
    }

    public static Address findPhysicalAddress(EmbeddedCacheManager ecm) {
        Transport transport = (Transport)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm).getComponent(Transport.class);
        if (transport == null) {
            return null;
        }
        List addresses = transport.getPhysicalAddresses();
        if (addresses.isEmpty()) {
            return ecm.getAddress();
        }
        return (Address)addresses.get(0);
    }

    public static int findPort(Address address) {
        int port = 0;
        if (address instanceof JGroupsAddress && ((JGroupsAddress)address).getJGroupsAddress() instanceof IpAddress) {
            JGroupsAddress jAddress = (JGroupsAddress)address;
            port = ((IpAddress)jAddress.getJGroupsAddress()).getPort();
        }
        return port;
    }

    public static String getOnlyIp(Address address) {
        if (address instanceof JGroupsAddress && ((JGroupsAddress)address).getJGroupsAddress() instanceof IpAddress) {
            JGroupsAddress jAddress = (JGroupsAddress)address;
            return ((IpAddress)jAddress.getJGroupsAddress()).getIpAddress().getHostAddress();
        }
        return address.toString();
    }

    static IntSet ownedSlots(Address member, ConsistentHash ch, SegmentSlotRelation ssr) {
        IntSet slots = IntSets.mutableEmptySet();
        Iterator iterator = ch.getPrimarySegmentsForOwner(member).iterator();
        while (iterator.hasNext()) {
            int segment = (Integer)iterator.next();
            slots.addAll(ssr.segmentToSlots(segment));
        }
        return IntSets.immutableSet((IntSet)slots);
    }
}

