/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.LimitArgument;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.util.concurrent.CompletionStages;

public class SORT
extends RespCommand
implements Resp3Command {
    public static final char REPLACEMENT = '*';
    public static final String VALUE_PATTERN = "#";
    private boolean readonly = false;

    public SORT() {
        super(-2, 1, 1, 1);
    }

    public void disableStore() {
        this.readonly = true;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage sortedCollection;
        int pos = 0;
        byte[] key = arguments.get(pos++);
        SortableBucket.SortOptions sortOptions = new SortableBucket.SortOptions();
        byte[] destination = null;
        String pattern = null;
        ArrayList<String> getObjectsPatterns = new ArrayList<String>();
        block9: while (pos < arguments.size()) {
            switch (Arg.valueOf(new String(arguments.get(pos++)).toUpperCase()).ordinal()) {
                case 0: {
                    sortOptions.alpha = true;
                    continue block9;
                }
                case 1: {
                    sortOptions.asc = true;
                    continue block9;
                }
                case 2: {
                    sortOptions.asc = false;
                    continue block9;
                }
                case 4: {
                    if (this.readonly) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    destination = arguments.get(pos++);
                    continue block9;
                }
                case 5: {
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    pattern = new String(arguments.get(pos++));
                    continue block9;
                }
                case 3: {
                    LimitArgument limitArgument = LimitArgument.parse(handler, arguments, pos);
                    if (limitArgument.error) {
                        return handler.myStage();
                    }
                    sortOptions.offset = limitArgument.offset;
                    sortOptions.count = limitArgument.count;
                    pos = limitArgument.nextArgPos;
                    continue block9;
                }
                case 6: {
                    if (pos >= arguments.size()) {
                        RespErrorUtil.syntaxError(handler.allocator());
                        return handler.myStage();
                    }
                    getObjectsPatterns.add(new String(arguments.get(pos++)));
                    continue block9;
                }
            }
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        if ("nosort".equals(pattern) || pattern != null && !pattern.contains("*")) {
            sortOptions.skipSort = true;
        }
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        AdvancedCache cache = handler.cache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, vmt);
        if (pattern == null || sortOptions.skipSort) {
            sortedCollection = cache.getCacheEntryAsync((Object)key).thenApply(e -> {
                if (e == null) {
                    return Collections.emptyList();
                }
                Object value = e.getValue();
                if (value instanceof SortableBucket) {
                    SortableBucket sortableBucket = (SortableBucket)value;
                    return sortableBucket.sort(sortOptions);
                }
                throw new ClassCastException();
            });
        } else {
            String finalPattern = pattern;
            int index = pattern.indexOf(42);
            sortedCollection = CompletionStages.handleAndCompose((CompletionStage)cache.getCacheEntryAsync((Object)key), (e, t) -> {
                if (e == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                Object value = e.getValue();
                if (value instanceof SortableBucket) {
                    SortableBucket sortableBucket = (SortableBucket)value;
                    return CompletableFutures.sequence(sortableBucket.stream().map(wrappedValue -> {
                        byte[] computedWeightKey = SORT.computePatternKey(finalPattern, index, (byte[])wrappedValue.get());
                        return handler.cache().getAsync((Object)computedWeightKey).thenApply(w -> {
                            if (w == null) {
                                return new ScoredValue(Double.valueOf(1.0), wrappedValue);
                            }
                            MultimapObjectWrapper wrappedWeight = new MultimapObjectWrapper(w);
                            return new ScoredValue(wrappedWeight.asDouble(), wrappedValue);
                        });
                    }).collect(Collectors.toList())).thenApply(list -> sortableBucket.sort(list.stream(), sortOptions));
                }
                throw new ClassCastException();
            });
        }
        if (!getObjectsPatterns.isEmpty()) {
            CompletionStage<List<byte[]>> resultingList = CompletionStages.handleAndCompose((CompletionStage)sortedCollection, (collection, t) -> CompletableFutures.sequence(getObjectsPatterns.stream().map(getPattern -> {
                if (getPattern.equals(VALUE_PATTERN)) {
                    return CompletableFuture.completedFuture(collection.stream().map(sv -> (byte[])sv.getValue()).collect(Collectors.toList()));
                }
                int index = getPattern.indexOf(42);
                if (index < 0) {
                    return CompletableFuture.completedFuture(Stream.generate(() -> null).limit(collection.size()).collect(Collectors.toList()));
                }
                return CompletableFutures.sequence(collection.stream().map(s -> handler.cache().getCacheEntryAsync((Object)SORT.computePatternKey(getPattern, index, (byte[])s.getValue())).thenApply(v -> {
                    if (v == null || ((byte[])v.getValue()).getClass() != byte[].class) {
                        return null;
                    }
                    return (byte[])v.getValue();
                })).collect(Collectors.toList()));
            }).collect(Collectors.toList()))).thenApply(patternGetResults -> {
                if (patternGetResults.isEmpty()) {
                    return Collections.emptyList();
                }
                int size = ((List)patternGetResults.get(0)).size();
                ArrayList<byte[]> finalResult = new ArrayList<byte[]>(patternGetResults.size() * size);
                for (int i = 0; i < size; ++i) {
                    for (List current : patternGetResults) {
                        finalResult.add((byte[])current.get(i));
                    }
                }
                return finalResult;
            });
            if (destination != null) {
                return this.storeV(handler, ctx, destination, resultingList);
            }
            return handler.stageToReturn(resultingList, ctx, Consumers.GET_ARRAY_BICONSUMER);
        }
        if (destination != null) {
            return this.store(handler, ctx, destination, sortedCollection);
        }
        return handler.stageToReturn(sortedCollection, ctx, Consumers.GET_OBJ_WRAPPER_ARRAY_BICONSUMER);
    }

    private static byte[] computePatternKey(String pattern, int index, byte[] value) {
        String computedKey = pattern.substring(0, index) + new String(value) + pattern.substring(index + 1);
        return computedKey.getBytes();
    }

    private CompletionStage<RespRequestHandler> storeV(Resp3Handler handler, ChannelHandlerContext ctx, byte[] destination, CompletionStage<List<byte[]>> resultingList) {
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        CompletionStage cs = resultingList.thenCompose(values -> listMultimap.replace((Object)destination, values));
        return handler.stageToReturn(cs, ctx, Consumers.LONG_BICONSUMER);
    }

    private CompletionStage<RespRequestHandler> store(Resp3Handler handler, ChannelHandlerContext ctx, byte[] destination, CompletionStage<List<ScoredValue<byte[]>>> sortedList) {
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        CompletionStage cs = sortedList.thenCompose(values -> listMultimap.replace((Object)destination, values.stream().map(ScoredValue::getValue).collect(Collectors.toList())));
        return handler.stageToReturn(cs, ctx, Consumers.LONG_BICONSUMER);
    }

    public static enum Arg {
        ALPHA,
        ASC,
        DESC,
        LIMIT,
        STORE,
        BY,
        GET;

    }
}

