/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.hll;

import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.hll.HyperLogLog;
import org.infinispan.util.function.SerializableFunction;

public class PFADD
extends RespCommand
implements Resp3Command {
    public PFADD() {
        super(-2, 1, 1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        FunctionalMap.ReadWriteMap cache = ReadWriteMapImpl.create((FunctionalMapImpl)FunctionalMapImpl.create(handler.typedCache(null)));
        ArrayList<byte[]> elements = new ArrayList<byte[]>(arguments.subList(1, arguments.size()));
        CompletionStage cs = cache.eval((Object)key, (SerializableFunction & Serializable)view -> {
            HyperLogLog hll = PFADD.parseHLL(view.find().orElse(null));
            if (hll == null) {
                return UpdateStatus.NO_OP.ordinal();
            }
            boolean changed = view.peek().isEmpty();
            for (byte[] el : elements) {
                if (!hll.add(el)) continue;
                changed = true;
            }
            if (!changed) {
                return UpdateStatus.NO_CHANGE.ordinal();
            }
            view.set((Object)hll, new MetaParam.Writable[0]);
            return UpdateStatus.ADDED.ordinal();
        }).thenApply(UpdateStatus::fromOrdinal);
        return handler.stageToReturn(cs, ctx, (res, buf) -> {
            switch (res.ordinal()) {
                case 1: {
                    Consumers.LONG_BICONSUMER.accept(0L, (ByteBufPool)buf);
                    break;
                }
                case 2: {
                    Consumers.LONG_BICONSUMER.accept(1L, (ByteBufPool)buf);
                    break;
                }
                case 0: {
                    RespErrorUtil.wrongType(handler.allocator());
                }
            }
        });
    }

    private static HyperLogLog parseHLL(Object stored) {
        if (stored == null) {
            return new HyperLogLog();
        }
        if (stored instanceof HyperLogLog) {
            return (HyperLogLog)stored;
        }
        return null;
    }

    private static enum UpdateStatus {
        NO_OP,
        NO_CHANGE,
        ADDED;

        private static final UpdateStatus[] values;

        public static UpdateStatus fromOrdinal(int ordinal) {
            return values[ordinal];
        }

        static {
            values = UpdateStatus.values();
        }
    }
}

