/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class SINTER
extends RespCommand
implements Resp3Command {
    public SINTER() {
        super(-2, 1, -1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, arguments);
        CompletionStage allEntries = esc.getAll(uniqueKeys).thenApply(sets -> SINTER.checkTypeOrEmpty(sets, uniqueKeys.size()));
        return handler.stageToReturn(((CompletableFuture)allEntries).thenApply(sets -> SINTER.intersect(sets.values(), 0)), ctx, Resp3Response.SET_BULK_STRING);
    }

    public static Set<byte[]> getUniqueKeys(Resp3Handler handler, List<byte[]> arguments) {
        Set wrappedArgs = arguments.stream().map(WrappedByteArray::new).collect(Collectors.toSet());
        return wrappedArgs.stream().map(WrappedByteArray::getBytes).collect(Collectors.toSet());
    }

    public static Map<byte[], SetBucket<byte[]>> checkTypeOrEmpty(Map<byte[], SetBucket<byte[]>> m, int count) {
        boolean empty = false;
        for (SetBucket<byte[]> it : m.values()) {
            empty |= it.isEmpty() || empty;
        }
        if (m.size() < count || empty) {
            return Collections.emptyMap();
        }
        return m;
    }

    public static Set<byte[]> checkTypesAndReturnEmpty(Collection<SetBucket<byte[]>> buckets) {
        for (SetBucket<byte[]> setBucket : buckets) {
        }
        return Collections.emptySet();
    }

    public static Set<byte[]> intersect(Collection<SetBucket<byte[]>> buckets, int limit) {
        Iterator<SetBucket<byte[]>> iter = buckets.iterator();
        if (!iter.hasNext()) {
            return Collections.emptySet();
        }
        SetBucket<byte[]> minSet = iter.next();
        if (minSet.isEmpty()) {
            return Collections.emptySet();
        }
        while (iter.hasNext() && !minSet.isEmpty()) {
            SetBucket<byte[]> el = iter.next();
            minSet = minSet.size() <= el.size() ? minSet : el;
        }
        HashSet<byte[]> result = new HashSet<byte[]>();
        for (byte[] el : minSet.toList()) {
            if (!buckets.stream().allMatch(set -> set.contains((Object)el))) continue;
            result.add(el);
            if (limit <= 0 || result.size() < limit) continue;
            break;
        }
        return result;
    }
}

