/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class ZINTERCARD
extends RespCommand
implements Resp3Command {
    public static final String LIMIT = "LIMIT";

    public ZINTERCARD() {
        super(-3, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        int numberOfKeysArg;
        int pos = 0;
        try {
            numberOfKeysArg = ArgumentUtils.toInt(arguments.get(pos++));
        }
        catch (NumberFormatException ex) {
            RespErrorUtil.valueNotInteger(handler.allocator());
            return handler.myStage();
        }
        if (numberOfKeysArg <= 0) {
            RespErrorUtil.customError("at least 1 input key is needed for '" + this.getName().toLowerCase() + "' command", handler.allocator());
            return handler.myStage();
        }
        ArrayList<byte[]> keys = new ArrayList<byte[]>(numberOfKeysArg);
        for (int i = 0; i < numberOfKeysArg && pos < arguments.size(); ++i) {
            keys.add(arguments.get(pos++));
        }
        if (keys.size() < numberOfKeysArg) {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        int limit = -1;
        if (pos < arguments.size()) {
            String arg;
            if (!LIMIT.equals((arg = new String(arguments.get(pos++))).toUpperCase())) {
                RespErrorUtil.syntaxError(handler.allocator());
                return handler.myStage();
            }
            boolean invalidLimit = false;
            try {
                limit = ArgumentUtils.toInt(arguments.get(pos++));
                if (limit < 0) {
                    invalidLimit = true;
                }
            }
            catch (NumberFormatException ex) {
                invalidLimit = true;
            }
            if (invalidLimit) {
                RespErrorUtil.customError("LIMIT can't be negative", handler.allocator());
                return handler.myStage();
            }
        }
        if (pos < arguments.size()) {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        CompletionStage<Long> aggValues = sortedSetCache.inter((Object)((byte[])keys.get(0)), null, 1.0, SortedSetBucket.AggregateFunction.SUM);
        int finalLimit = limit;
        for (int i = 1; i < keys.size(); ++i) {
            byte[] setName = (byte[])keys.get(i);
            aggValues = aggValues.thenCompose(c1 -> c1.isEmpty() || ZINTERCARD.isLimitReached(c1.size(), finalLimit) ? CompletableFuture.completedFuture(c1) : sortedSetCache.inter((Object)setName, c1, 1.0, SortedSetBucket.AggregateFunction.SUM));
        }
        CompletionStage<Long> cs = aggValues.thenApply(res -> ZINTERCARD.cardinalityResult(res.size(), finalLimit));
        return handler.stageToReturn(cs, ctx, Resp3Response.INTEGER);
    }

    private static boolean isLimitReached(int interResultSize, int finalLimit) {
        return finalLimit > 0 && interResultSize >= finalLimit;
    }

    private static long cardinalityResult(int interResultSize, int finalLimit) {
        return finalLimit > 0 && interResultSize > finalLimit ? (long)finalLimit : (long)interResultSize;
    }
}

