/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.response;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.ByteBufferUtils;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Response;

public class LCSResponse {
    public static final BiConsumer<LCSResponse, ByteBufPool> SERIALIZER = (res, alloc) -> Resp3Response.write(res, alloc, LcsResponseSerializer.INSTANCE);
    public ArrayList<long[]> idx;
    public byte[] lcs;
    public int[][] C;
    public int len;

    private static final class LcsResponseSerializer
    implements JavaObjectSerializer<LCSResponse> {
        private static final LcsResponseSerializer INSTANCE = new LcsResponseSerializer();
        private static final byte[] MATCHES = new byte[]{109, 97, 116, 99, 104, 101, 115};
        private static final byte[] LEN = new byte[]{108, 101, 110};

        private LcsResponseSerializer() {
        }

        @Override
        public void accept(LCSResponse res, ByteBufPool alloc) {
            if (res.lcs != null) {
                Resp3Response.string(res.lcs, alloc);
                return;
            }
            if (res.idx == null) {
                Resp3Response.integers(res.len, alloc);
                return;
            }
            ByteBufferUtils.writeNumericPrefix((byte)37, 2L, alloc);
            Resp3Response.string(MATCHES, alloc);
            ByteBufferUtils.writeNumericPrefix((byte)42, res.idx.size(), alloc);
            for (long[] match : res.idx) {
                int size = match.length > 4 ? 3 : 2;
                ByteBufferUtils.writeNumericPrefix((byte)42, size, alloc);
                ByteBufferUtils.writeNumericPrefix((byte)42, 2L, alloc);
                Resp3Response.integers(match[0], alloc);
                Resp3Response.integers(match[1], alloc);
                ByteBufferUtils.writeNumericPrefix((byte)42, 2L, alloc);
                Resp3Response.integers(match[2], alloc);
                Resp3Response.integers(match[3], alloc);
                if (match.length <= 4) continue;
                Resp3Response.integers(match[4], alloc);
            }
            Resp3Response.string(LEN, alloc);
            Resp3Response.integers(res.len, alloc);
        }
    }
}

