/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.Arrays;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.configuration.CorsRuleConfiguration;

public class CorsRuleConfigurationBuilder
implements Builder<CorsRuleConfiguration> {
    private static final String[] ALLOW_ALL_ORIGINS = new String[]{"*"};
    private final AttributeSet attributes = CorsRuleConfiguration.attributeDefinitionSet();
    private final Attribute<String> name = this.attributes.attribute(CorsRuleConfiguration.NAME);
    private final Attribute<Long> maxAge = this.attributes.attribute(CorsRuleConfiguration.MAX_AGE);
    private final Attribute<Boolean> allowCredentials = this.attributes.attribute(CorsRuleConfiguration.ALLOW_CREDENTIALS);
    private final Attribute<String[]> allowedHeaders = this.attributes.attribute(CorsRuleConfiguration.ALLOW_HEADERS);
    private final Attribute<String[]> allowedOrigins = this.attributes.attribute(CorsRuleConfiguration.ALLOW_ORIGINS);
    private final Attribute<String[]> allowedMethods = this.attributes.attribute(CorsRuleConfiguration.ALLOW_METHODS);
    private final Attribute<String[]> exposeHeaders = this.attributes.attribute(CorsRuleConfiguration.EXPOSE_HEADERS);

    CorsRuleConfigurationBuilder() {
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CorsRuleConfigurationBuilder name(String value) {
        this.name.set((Object)value);
        return this;
    }

    public CorsRuleConfigurationBuilder allowCredentials(boolean allow) {
        this.allowCredentials.set((Object)allow);
        return this;
    }

    public CorsRuleConfigurationBuilder maxAge(long value) {
        this.maxAge.set((Object)value);
        return this;
    }

    public CorsRuleConfigurationBuilder allowOrigins(String[] values) {
        this.allowedOrigins.set((Object)values);
        return this;
    }

    public CorsRuleConfigurationBuilder allowMethods(String[] values) {
        this.allowedMethods.set((Object)values);
        return this;
    }

    public CorsRuleConfigurationBuilder allowHeaders(String[] values) {
        this.allowedHeaders.set((Object)values);
        return this;
    }

    public CorsRuleConfigurationBuilder exposeHeaders(String[] values) {
        this.exposeHeaders.set((Object)values);
        return this;
    }

    public CorsRuleConfiguration create() {
        CorsConfig corsConfig = this.createCors();
        return new CorsRuleConfiguration(this.attributes.protect(), corsConfig);
    }

    private CorsConfig createCors() {
        boolean isAllowAll = Arrays.equals((Object[])this.allowedOrigins.get(), ALLOW_ALL_ORIGINS);
        CorsConfigBuilder builder = CorsConfigBuilder.forAnyOrigin();
        if (this.allowedOrigins.isModified() && !isAllowAll) {
            builder = CorsConfigBuilder.forOrigins((String[])((String[])this.allowedOrigins.get()));
        }
        if (this.allowCredentials.isModified() && this.allowCredentials.get() != null && ((Boolean)this.allowCredentials.get()).booleanValue()) {
            builder.allowCredentials();
        }
        if (this.maxAge.isModified()) {
            builder.maxAge(((Long)this.maxAge.get()).longValue());
        }
        if (this.allowedHeaders.isModified()) {
            builder.allowedRequestHeaders((String[])this.allowedHeaders.get());
        }
        if (this.allowedMethods.isModified()) {
            HttpMethod[] methods = (HttpMethod[])Arrays.stream((String[])this.allowedMethods.get()).map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
            builder.allowedRequestMethods(methods);
        }
        if (this.exposeHeaders.isModified()) {
            builder.exposeHeaders((String[])this.exposeHeaders.get());
        }
        return builder.build();
    }

    public CorsRuleConfigurationBuilder read(CorsRuleConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

