/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.rest.ServerSentEvent;

public class EventStream
implements Closeable {
    private final Consumer<EventStream> onOpen;
    private final Runnable onClose;
    private ChannelHandlerContext ctx;

    public EventStream(Consumer<EventStream> onOpen, Runnable onClose) {
        this.onOpen = onOpen;
        this.onClose = onClose;
    }

    public CompletionStage<Void> sendEvent(ServerSentEvent e) {
        if (this.ctx != null) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            this.ctx.writeAndFlush((Object)e).addListener(v -> cf.complete(null));
            return cf;
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public void close() throws IOException {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void setChannelHandlerContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        ctx.channel().closeFuture().addListener(f -> this.close());
        if (this.onOpen != null) {
            this.onOpen.accept(this);
        }
    }
}

