/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.propagation.TextMapGetter;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.server.core.telemetry.TelemetryService;

public class RestTelemetryService {
    private static final TextMapGetter<RestRequest> REST_REQUEST_TEXT_MAP_GETTER = new TextMapGetter<RestRequest>(){

        public String get(RestRequest carrier, String key) {
            return carrier.header(key);
        }

        public Iterable<String> keys(RestRequest carrier) {
            return carrier.headersKeys();
        }
    };
    private final TelemetryService telemetryService;

    public RestTelemetryService(TelemetryService telemetryService) {
        this.telemetryService = telemetryService;
    }

    public Span requestStart(String operationName, RestRequest request) {
        return this.telemetryService.requestStart(operationName, REST_REQUEST_TEXT_MAP_GETTER, (Object)request);
    }

    public void requestEnd(Object span) {
        this.telemetryService.requestEnd(span);
    }

    public void recordException(Object span, Throwable throwable) {
        this.telemetryService.recordException(span, throwable);
    }
}

