/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.reactivex.rxjava3.core.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.EncoderEntryMapper;
import org.infinispan.cache.impl.EncoderKeyMapper;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;
import org.infinispan.query.core.stats.impl.SearchStatsRetriever;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.reactive.publisher.PublisherTransformers;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.ServerSentEvent;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.distribution.CacheDistributionInfo;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.BaseCacheResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.stream.CacheChunkedStream;
import org.infinispan.rest.stream.CacheEntryStreamProcessor;
import org.infinispan.rest.stream.CacheKeyStreamProcessor;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.reactivestreams.Publisher;

public class CacheResourceV2
extends BaseCacheResource
implements ResourceHandler {
    private static final int STREAM_BATCH_SIZE = 1000;
    private static final String MIGRATOR_NAME = "hotrod";
    private final ParserRegistry parserRegistry = new ParserRegistry();
    private final InternalCacheRegistry internalCacheRegistry;
    private final ServerStateManager serverStateManager;

    public CacheResourceV2(InvocationHelper invocationHelper, InfinispanTelemetry telemetryService) {
        super(invocationHelper, telemetryService);
        EmbeddedCacheManager cacheManager = invocationHelper.getRestCacheManager().getInstance();
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager);
        this.serverStateManager = (ServerStateManager)globalComponentRegistry.getComponent(ServerStateManager.class);
        this.internalCacheRegistry = (InternalCacheRegistry)globalComponentRegistry.getComponent(InternalCacheRegistry.class);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.GET).path("/v2/caches/{cacheName}/{cacheKey}").withAction("distribution").handleWith(this::getKeyDistribution).invocation().method(Method.GET).path("/v2/caches/{cacheName}/{cacheKey}").withAction("distribution").handleWith(this::getKeyDistribution).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("keys").handleWith(this::streamKeys).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("entries").handleWith(this::streamEntries).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("listen").handleWith(this::cacheListen).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}").withAction("config").handleWith(this::getCacheConfig).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("stats").handleWith(this::getCacheStats).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("stats-reset").permission(AuthorizationPermission.ADMIN).handleWith(this::resetCacheStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("distribution").handleWith(this::getCacheDistribution).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("get-mutable-attributes").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheConfigMutableAttributes).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("get-mutable-attribute").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheConfigMutableAttribute).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("set-mutable-attribute").permission(AuthorizationPermission.ADMIN).handleWith(this::setCacheConfigMutableAttribute).invocation().methods(Method.GET).path("/v2/caches/").handleWith(this::getCacheNames).invocation().methods(Method.GET).deprecated().path("/v2/cache-managers/{name}/caches").handleWith(this::getCaches).invocation().methods(Method.GET).path("/v2/caches").withAction("detailed").handleWith(this::getCaches).invocation().methods(Method.GET).path("/v2/caches").withAction("role-accessible").permission(AuthorizationPermission.ADMIN).name("CACHES PER ROLE LIST").auditContext(AuditContext.CACHE).handleWith(this::getCacheNamesPerRole).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("health").handleWith(this::getCacheHealth).invocation().methods(Method.POST, Method.PUT).path("/v2/caches/{cacheName}").handleWith(this::createOrUpdate).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}").handleWith(this::removeCache).invocation().method(Method.HEAD).path("/v2/caches/{cacheName}").handleWith(this::cacheExists).invocation().method(Method.GET).path("/v2/caches/{cacheName}").withAction("get-availability").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheAvailability).invocation().method(Method.POST).path("/v2/caches/{cacheName}").withAction("set-availability").permission(AuthorizationPermission.ADMIN).handleWith(this::setCacheAvailability).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("clear").handleWith(this::clearEntireCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("size").handleWith(this::getSize).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("sync-data").handleWith(this::syncData).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").deprecated().withAction("disconnect-source").handleWith(this::deleteSourceConnection).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::addSourceConnection).invocation().methods(Method.DELETE).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::deleteSourceConnection).invocation().methods(Method.HEAD).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::hasSourceConnections).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::getSourceConnection).invocation().methods(Method.GET, Method.POST).path("/v2/caches/{cacheName}").withAction("search").permission(AuthorizationPermission.BULK_READ).handleWith(this.queryAction::search).invocation().methods(Method.POST).path("/v2/caches").withAction("toJSON").deprecated().handleWith(this::convertToJson).invocation().methods(Method.POST).path("/v2/caches").withAction("convert").handleWith(this::convert).invocation().methods(Method.POST).path("/v2/caches").withAction("compare").handleWith(this::compare).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").handleWith(this::getAllDetails).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("enable-rebalancing").permission(AuthorizationPermission.ADMIN).name("ENABLE REBALANCE").auditContext(AuditContext.CACHE).handleWith(r -> this.setRebalancing(true, (RestRequest)r)).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("disable-rebalancing").permission(AuthorizationPermission.ADMIN).name("DISABLE REBALANCE").auditContext(AuditContext.CACHE).handleWith(r -> this.setRebalancing(false, (RestRequest)r)).invocation().method(Method.POST).path("/v2/caches/{cacheName}").withAction("initialize").permission(AuthorizationPermission.ADMIN).name("Initialize cache").auditContext(AuditContext.CACHE).handleWith(this::reinitializeCache).create();
    }

    private CompletionStage<RestResponse> getCaches(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        EmbeddedCacheManager subjectCacheManager = cacheManager.withSubject(request.getSubject());
        HashSet cacheNames = new HashSet(subjectCacheManager.getAccessibleCacheNames());
        cacheNames.removeAll(this.internalCacheRegistry.getInternalCacheNames());
        Set ignoredCaches = this.serverStateManager.getIgnoredCaches();
        List cachesHealth = SecurityActions.getHealth((EmbeddedCacheManager)subjectCacheManager).getCacheHealth(cacheNames);
        LocalTopologyManager localTopologyManager = null;
        Boolean clusterRebalancingEnabled = null;
        try {
            localTopologyManager = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getLocalTopologyManager();
            if (localTopologyManager != null) {
                clusterRebalancingEnabled = localTopologyManager.isRebalancingEnabled();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LocalTopologyManager finalLocalTopologyManager = localTopologyManager;
        Boolean finalClusterRebalancingEnabled = clusterRebalancingEnabled;
        boolean pretty = ResourceUtil.isPretty(request);
        return Flowable.fromIterable((Iterable)cachesHealth).map(chHealth -> this.getCacheInfo(request, cacheManager, subjectCacheManager, ignoredCaches, finalLocalTopologyManager, finalClusterRebalancingEnabled, (CacheHealth)chHealth)).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList()).map(cacheInfos -> ResourceUtil.addEntityAsJson(Json.make((Object)cacheInfos), responseBuilder, pretty).build()).toCompletionStage();
    }

    private CacheInfo getCacheInfo(RestRequest request, EmbeddedCacheManager cacheManager, EmbeddedCacheManager subjectCacheManager, Set<String> ignoredCaches, LocalTopologyManager finalLocalTopologyManager, Boolean finalClusterRebalancingEnabled, CacheHealth chHealth) {
        HealthStatus cacheHealth;
        String cacheName;
        CacheInfo cacheInfo = new CacheInfo();
        cacheInfo.name = cacheName = chHealth.getCacheName();
        cacheInfo.health = cacheHealth = chHealth.getStatus();
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)subjectCacheManager, (String)cacheName);
        cacheInfo.type = cacheConfiguration.clustering().cacheMode().toCacheType();
        boolean isPersistent = false;
        if (chHealth.getStatus() != HealthStatus.FAILED) {
            PersistenceManager pm = SecurityActions.getPersistenceManager((EmbeddedCacheManager)cacheManager, (String)cacheName);
            isPersistent = pm.isEnabled();
        }
        cacheInfo.simpleCache = cacheConfiguration.simpleCache();
        cacheInfo.transactional = cacheConfiguration.transaction().transactionMode().isTransactional();
        cacheInfo.persistent = isPersistent;
        cacheInfo.persistent = cacheConfiguration.persistence().usingStores();
        cacheInfo.bounded = cacheConfiguration.memory().whenFull().isEnabled();
        cacheInfo.secured = cacheConfiguration.security().authorization().enabled();
        cacheInfo.indexed = cacheConfiguration.indexing().enabled();
        cacheInfo.hasRemoteBackup = cacheConfiguration.sites().hasBackups();
        if (ignoredCaches.contains(cacheName)) {
            cacheInfo.status = "IGNORED";
        } else {
            switch (cacheHealth) {
                case FAILED: {
                    cacheInfo.status = ComponentStatus.FAILED.toString();
                    break;
                }
                case INITIALIZING: {
                    cacheInfo.status = ComponentStatus.INITIALIZING.toString();
                    break;
                }
                default: {
                    AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
                    cacheInfo.status = cache.getStatus().toString();
                }
            }
        }
        if (finalLocalTopologyManager != null && finalClusterRebalancingEnabled != null) {
            Boolean perCacheRebalancing = null;
            if (finalClusterRebalancingEnabled.booleanValue()) {
                try {
                    perCacheRebalancing = finalLocalTopologyManager.isCacheRebalancingEnabled(cacheName);
                }
                catch (Exception exception) {}
            } else {
                perCacheRebalancing = Boolean.FALSE;
            }
            cacheInfo.rebalancing_enabled = perCacheRebalancing;
        }
        return cacheInfo;
    }

    private CompletionStage<RestResponse> getSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        PersistenceManager persistenceManager = SecurityActions.getPersistenceManager((EmbeddedCacheManager)this.invocationHelper.getRestCacheManager().getInstance(), (String)cache.getName());
        ArrayList remoteStores = new ArrayList(persistenceManager.getStores(RemoteStore.class));
        if (remoteStores.isEmpty()) {
            builder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(builder.build());
        }
        if (remoteStores.size() != 1) {
            throw Log.REST.multipleRemoteStores();
        }
        RemoteStoreConfiguration storeConfiguration = ((RemoteStore)remoteStores.get(0)).getConfiguration();
        builder.entity(SerializationUtils.toJson((RemoteStoreConfiguration)storeConfiguration));
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> hasSourceConnections(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)ComponentRegistry.componentOf(cache, RollingUpgradeManager.class);
        return CompletableFuture.supplyAsync(() -> {
            if (!upgradeManager.isConnected(MIGRATOR_NAME)) {
                builder.status(HttpResponseStatus.NOT_FOUND);
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> deleteSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)ComponentRegistry.componentOf(cache, RollingUpgradeManager.class);
        if (upgradeManager.isConnected(MIGRATOR_NAME)) {
            upgradeManager.disconnectSource(MIGRATOR_NAME);
        } else {
            builder.status(HttpResponseStatus.NOT_MODIFIED);
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> addSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        ContentSource contents = request.contents();
        byte[] config = contents.rawContent();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        if (config == null || config.length == 0) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.BAD_REQUEST, "A remote-store config must be provided").toFuture();
        }
        String storeConfig = new String(config, StandardCharsets.UTF_8);
        Json read = Json.read((String)storeConfig);
        if (!read.isObject() || read.at("remote-store") == null || read.asMap().size() != 1) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.BAD_REQUEST, "Invalid remote-store JSON description: a single remote-store element must be provided").toFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            RollingUpgradeManager upgradeManager = (RollingUpgradeManager)ComponentRegistry.componentOf((Cache)cache, RollingUpgradeManager.class);
            try {
                RemoteStoreConfiguration storeConfiguration = SerializationUtils.fromJson((String)read.toString());
                if (!upgradeManager.isConnected(MIGRATOR_NAME)) {
                    upgradeManager.connectSource(MIGRATOR_NAME, (StoreConfiguration)storeConfiguration);
                } else {
                    builder.status(HttpResponseStatus.NOT_MODIFIED);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> syncData(RestRequest request) {
        int threads;
        int readBatch;
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        String readBatchReq = request.getParameter("read-batch");
        String threadsReq = request.getParameter("threads");
        int n = readBatch = readBatchReq == null ? 10000 : Integer.parseInt(readBatchReq);
        if (readBatch < 1) {
            throw Log.REST.illegalArgument("read-batch", readBatch);
        }
        int n2 = threads = request.getParameter("threads") == null ? ProcessorInfo.availableProcessors() : Integer.parseInt(threadsReq);
        if (threads < 1) {
            throw Log.REST.illegalArgument("threads", threads);
        }
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)ComponentRegistry.componentOf(cache, RollingUpgradeManager.class);
        return CompletableFuture.supplyAsync(() -> {
            long hotrod = upgradeManager.synchronizeData(MIGRATOR_NAME, readBatch, threads);
            builder.entity(Log.REST.synchronizedEntries(hotrod));
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> convert(RestRequest request, MediaType toType) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        boolean pretty = Boolean.parseBoolean(request.getParameter("pretty"));
        String contents = request.contents().asString();
        if (contents == null || contents.isEmpty()) {
            throw Log.REST.missingContent();
        }
        return CompletableFuture.supplyAsync(() -> {
            ParserRegistry parserRegistry = this.invocationHelper.getParserRegistry();
            Properties properties = new Properties();
            ConfigurationReader reader = ConfigurationReader.from((String)contents).withResolver(ConfigurationResourceResolvers.DEFAULT).withType(request.contentType()).withProperties(properties).withNamingStrategy(NamingStrategy.KEBAB_CASE).build();
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
            parserRegistry.parse(reader, holder);
            Map.Entry entry = holder.getNamedConfigurationBuilders().entrySet().iterator().next();
            Configuration configuration = ((ConfigurationBuilder)entry.getValue()).build();
            StringBuilderWriter out = new StringBuilderWriter();
            try (ConfigurationWriter writer = ConfigurationWriter.to((Writer)out).withType(toType).clearTextSecrets(true).prettyPrint(pretty).build();){
                parserRegistry.serialize(writer, (String)entry.getKey(), configuration);
            }
            return responseBuilder.contentType(toType).entity(out.toString()).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest request) {
        return this.convert(request, MediaType.APPLICATION_JSON);
    }

    private CompletionStage<RestResponse> convert(RestRequest request) {
        return this.convert(request, MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML));
    }

    private CompletionStage<RestResponse> compare(RestRequest request) {
        boolean result;
        boolean ignoreMutable = Boolean.parseBoolean(request.getParameter("ignoreMutable"));
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        MediaType contentType = request.contentType();
        if (!contentType.match(MediaType.MULTIPART_FORM_DATA)) {
            throw Log.REST.wrongMediaType("multipart/form-data", contentType.toString());
        }
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(false);
        FullHttpRequest nettyRequest = ((NettyRestRequest)request).getFullHttpRequest();
        HttpPostMultipartRequestDecoder decoder = new HttpPostMultipartRequestDecoder((HttpDataFactory)factory, (HttpRequest)nettyRequest);
        List datas = decoder.getBodyHttpDatas();
        if (datas.size() != 2) {
            throw Log.REST.cacheCompareWrongContent();
        }
        MemoryAttribute one = (MemoryAttribute)datas.get(0);
        MemoryAttribute two = (MemoryAttribute)datas.get(1);
        String s1 = one.content().toString(StandardCharsets.UTF_8);
        String s2 = two.content().toString(StandardCharsets.UTF_8);
        ParserRegistry parserRegistry = this.invocationHelper.getParserRegistry();
        Map b1 = parserRegistry.parse(s1, null).getNamedConfigurationBuilders();
        Map b2 = parserRegistry.parse(s2, null).getNamedConfigurationBuilders();
        if (b1.size() != 1 || b2.size() != 1) {
            throw Log.REST.cacheCompareWrongContent();
        }
        Configuration c1 = ((ConfigurationBuilder)b1.values().iterator().next()).build();
        Configuration c2 = ((ConfigurationBuilder)b2.values().iterator().next()).build();
        if (ignoreMutable) {
            try {
                c1.validateUpdate(null, (ConfigurationElement)c2);
                result = true;
            }
            catch (Throwable t) {
                result = false;
                responseBuilder.entity(Util.unwrapExceptionMessage((Throwable)RestRequestHandler.filterCause(t)));
            }
        } else {
            result = c1.equals((Object)c2);
        }
        return CompletableFuture.completedFuture(responseBuilder.status(result ? HttpResponseStatus.NO_CONTENT : HttpResponseStatus.CONFLICT).build());
    }

    private CompletionStage<RestResponse> streamKeys(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String batchParam = request.getParameter("batch");
        String limitParam = request.getParameter("limit");
        int batch = batchParam == null || batchParam.isEmpty() ? 1000 : Integer.parseInt(batchParam);
        int limit = limitParam == null || limitParam.isEmpty() ? -1 : Integer.parseInt(limitParam);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, MediaType.TEXT_PLAIN, MediaType.MATCH_ALL, request);
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        ComponentRegistry registry = SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache());
        ClusterPublisherManager cpm = (ClusterPublisherManager)registry.getClusterPublisherManager().wired();
        EncoderKeyMapper mapper = new EncoderKeyMapper(cache.getKeyDataConversion());
        mapper.injectDependencies(registry);
        SegmentPublisherSupplier sps = cpm.keyPublisher(null, null, null, 0L, DeliveryGuarantee.EXACTLY_ONCE, batch, PublisherTransformers.identity());
        Flowable flowable = Flowable.fromPublisher((Publisher)sps.publisherWithoutSegments()).map(e -> CacheChunkedStream.readContentAsBytes(mapper.apply(e)));
        if (limit > -1) {
            flowable = flowable.take((long)limit);
        }
        responseBuilder.entity(new CacheKeyStreamProcessor((Publisher<byte[]>)flowable));
        responseBuilder.contentType("application/json");
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> streamEntries(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String limitParam = request.getParameter("limit");
        String metadataParam = request.getParameter("metadata");
        String batchParam = request.getParameter("batch");
        String negotiateMediaType = request.getParameter("content-negotiation");
        int limit = limitParam == null ? -1 : Integer.parseInt(limitParam);
        boolean metadata = Boolean.parseBoolean(metadataParam);
        int batch = batchParam == null ? 1000 : Integer.parseInt(batchParam);
        boolean negotiate = Boolean.parseBoolean(negotiateMediaType);
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request).getAdvancedCache();
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager((AdvancedCache)cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
        MediaType keyMediaType = this.getMediaType(negotiate, cache, true);
        MediaType valueMediaType = this.getMediaType(negotiate, cache, false);
        AdvancedCache<Object, Object> typedCache = this.invocationHelper.getRestCacheManager().getCache(cacheName, keyMediaType, valueMediaType, request);
        ComponentRegistry registry = SecurityActions.getCacheComponentRegistry(typedCache);
        ClusterPublisherManager cpm = (ClusterPublisherManager)registry.getClusterPublisherManager().wired();
        InternalEntryFactory ief = (InternalEntryFactory)registry.getInternalEntryFactory().running();
        EncoderEntryMapper mapper = EncoderEntryMapper.newCacheEntryMapper((DataConversion)typedCache.getKeyDataConversion(), (DataConversion)typedCache.getValueDataConversion(), (InternalEntryFactory)ief);
        mapper.injectDependencies(registry);
        SegmentPublisherSupplier sps = cpm.entryPublisher(null, null, null, 0L, DeliveryGuarantee.EXACTLY_ONCE, batch, PublisherTransformers.identity());
        Flowable flowable = Flowable.fromPublisher((Publisher)sps.publisherWithoutSegments()).map(arg_0 -> ((EncoderEntryMapper)mapper).apply(arg_0));
        if (limit > -1) {
            flowable = flowable.take((long)limit);
        }
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        responseBuilder.entity(new CacheEntryStreamProcessor((Publisher<CacheEntry<?, ?>>)flowable, keyMediaType.match(MediaType.APPLICATION_JSON), valueMediaType.match(MediaType.APPLICATION_JSON), metadata));
        responseBuilder.contentType("application/json");
        responseBuilder.header(ResponseHeader.KEY_CONTENT_TYPE_HEADER.getValue(), keyMediaType.toString());
        responseBuilder.header(ResponseHeader.VALUE_CONTENT_TYPE_HEADER.getValue(), valueMediaType.toString());
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> cacheListen(RestRequest request) {
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN);
        String cacheName = request.variables().get("cacheName");
        boolean includeCurrentState = Boolean.parseBoolean(request.getParameter("includeCurrentState"));
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, accept, accept, request);
        BaseCacheListener listener = includeCurrentState ? new StatefulCacheListener((Cache<?, ?>)cache) : new StatelessCacheListener((Cache<?, ?>)cache);
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        responseBuilder.contentType(MediaType.TEXT_EVENT_STREAM).entity(listener.getEventStream());
        return cache.addListenerAsync((Object)listener).thenApply(v -> responseBuilder.build());
    }

    private MediaType getMediaType(boolean negotiate, AdvancedCache<?, ?> cache, boolean forKey) {
        MediaType storageMediaType = forKey ? cache.getKeyDataConversion().getStorageMediaType() : cache.getValueDataConversion().getStorageMediaType();
        boolean protoStreamEncoding = MediaType.APPLICATION_PROTOSTREAM.equals((Object)storageMediaType);
        if (negotiate) {
            return this.negotiateEntryMediaType(storageMediaType, protoStreamEncoding);
        }
        return protoStreamEncoding ? MediaType.APPLICATION_JSON : MediaType.TEXT_PLAIN;
    }

    private MediaType negotiateEntryMediaType(MediaType storage, boolean protoStreamEncoding) {
        boolean textSupported;
        EncoderRegistry encoderRegistry = this.invocationHelper.getEncoderRegistry();
        boolean encodingDefined = !MediaType.APPLICATION_UNKNOWN.equals((Object)storage);
        boolean jsonSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.APPLICATION_JSON);
        boolean bl = textSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.TEXT_PLAIN);
        if (protoStreamEncoding) {
            if (jsonSupported) {
                return MediaType.APPLICATION_JSON;
            }
            if (textSupported) {
                return MediaType.TEXT_PLAIN;
            }
        } else {
            if (textSupported) {
                return MediaType.TEXT_PLAIN;
            }
            if (jsonSupported) {
                return MediaType.APPLICATION_JSON;
            }
        }
        if (encodingDefined) {
            return storage.withEncoding("hex");
        }
        return MediaType.APPLICATION_OCTET_STREAM.withEncoding("hex");
    }

    private CompletionStage<RestResponse> removeCache(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            restCacheManager.getCacheManagerAdmin(request).removeCache(cacheName);
            return this.invocationHelper.newResponse(request).status(HttpResponseStatus.OK).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheExists(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
        } else {
            responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletableFuture<RestResponse> createOrUpdate(RestRequest request) {
        MediaType sourceType;
        EmbeddedCacheManagerAdmin administration;
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        List<String> template = request.parameters().get("template");
        String cacheName = request.variables().get("cacheName");
        EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = request.getAdminFlags();
        if (request.method() == Method.PUT) {
            if (adminFlags == null) {
                adminFlags = EnumSet.of(CacheContainerAdmin.AdminFlag.UPDATE);
            } else {
                adminFlags.add(CacheContainerAdmin.AdminFlag.UPDATE);
            }
        }
        EmbeddedCacheManagerAdmin initialAdmin = this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin embeddedCacheManagerAdmin = administration = adminFlags == null ? initialAdmin : (EmbeddedCacheManagerAdmin)initialAdmin.withFlags(adminFlags);
        if (template != null && !template.isEmpty()) {
            if (request.method() == Method.PUT) {
                throw Log.REST.wrongMethod(request.method().toString());
            }
            String templateName = template.iterator().next();
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, templateName);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        if (bytes == null || bytes.length == 0) {
            if (request.method() == Method.PUT) {
                throw Log.REST.wrongMethod(request.method().toString());
            }
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, (String)null);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        MediaType mediaType = sourceType = request.contentType() == null ? MediaType.APPLICATION_JSON : request.contentType();
        if (!(sourceType.match(MediaType.APPLICATION_JSON) || sourceType.match(MediaType.APPLICATION_XML) || sourceType.match(MediaType.APPLICATION_YAML))) {
            responseBuilder.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)this.invocationHelper.getRestCacheManager().getInstance());
        return CompletableFuture.supplyAsync(() -> {
            ConfigurationBuilder cfgBuilder;
            ConfigurationBuilderHolder holder = this.invocationHelper.getParserRegistry().parse(new String(bytes, StandardCharsets.UTF_8), sourceType);
            ConfigurationBuilder configurationBuilder = cfgBuilder = holder.getCurrentConfigurationBuilder() != null ? holder.getCurrentConfigurationBuilder() : new ConfigurationBuilder();
            if (request.method() == Method.PUT) {
                administration.getOrCreateCache(cacheName, cfgBuilder.build(globalConfiguration));
            } else {
                administration.createCache(cacheName, cfgBuilder.build(globalConfiguration));
            }
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheStats(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return CompletableFuture.supplyAsync(() -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), cache.getAdvancedCache().getStats().toJson(), ResourceUtil.isPretty(request)), this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> resetCacheStats(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return CompletableFuture.supplyAsync(() -> {
            cache.getAdvancedCache().getStats().reset();
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NO_CONTENT);
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheDistribution(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> cache = this.invocationHelper.getRestCacheManager();
        boolean pretty = ResourceUtil.isPretty(request);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> cache.cacheDistribution(cacheName, request), this.invocationHelper.getExecutor()).thenCompose(Function.identity())).thenApply(distributions -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.array((Object[])distributions.stream().map(CacheDistributionInfo::toJson).toArray()), pretty));
    }

    private CompletionStage<RestResponse> getKeyDistribution(RestRequest request) {
        boolean pretty = ResourceUtil.isPretty(request);
        return this.keyDistribution(request).thenApply(distribution -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), distribution.toJson(), pretty));
    }

    private CompletionStage<RestResponse> getAllDetails(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        boolean pretty = ResourceUtil.isPretty(request);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        return CompletableFuture.supplyAsync(() -> this.getDetailResponse(request, (Cache<?, ?>)cache, pretty), this.invocationHelper.getExecutor());
    }

    private RestResponse getDetailResponse(RestRequest request, Cache<?, ?> cache, boolean pretty) {
        Configuration configuration = SecurityActions.getCacheConfiguration((AdvancedCache)cache.getAdvancedCache());
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cacheManager);
        PersistenceManager persistenceManager = SecurityActions.getPersistenceManager((EmbeddedCacheManager)cacheManager, (String)cache.getName());
        Stats stats = null;
        Boolean rehashInProgress = null;
        Boolean indexingInProgress = null;
        Boolean queryable = null;
        try {
            stats = (Stats)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(ClusterCacheStats.class);
            DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
            rehashInProgress = distributionManager != null && distributionManager.isRehashInProgress();
        }
        catch (SecurityException distributionManager) {
            // empty catch block
        }
        Boolean rebalancingEnabled = null;
        try {
            LocalTopologyManager localTopologyManager = (LocalTopologyManager)SecurityActions.getCacheComponentRegistry((AdvancedCache)cache.getAdvancedCache()).getComponent(LocalTopologyManager.class);
            if (localTopologyManager != null) {
                rebalancingEnabled = localTopologyManager.isCacheRebalancingEnabled(cache.getName());
            }
        }
        catch (Exception localTopologyManager) {
            // empty catch block
        }
        Integer size = null;
        if (globalConfiguration.metrics().accurateSize()) {
            try {
                size = cache.size();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        indexingInProgress = this.reindexingInProgress(cache);
        queryable = this.invocationHelper.getRestCacheManager().isCacheQueryable(cache);
        boolean statistics = configuration.statistics().enabled();
        boolean indexed = configuration.indexing().enabled();
        CacheFullDetail fullDetail = new CacheFullDetail();
        fullDetail.stats = stats;
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(pretty).build();){
            this.invocationHelper.getParserRegistry().serialize(w, cache.getName(), configuration);
        }
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager((AdvancedCache)cache.getAdvancedCache());
        if (authorizationManager == null || authorizationManager.isPermissive()) {
            if (this.invocationHelper.getRestCacheManager().getAuthorizer().getPermissions(null, request.getSubject()).contains(AuthorizationPermission.ADMIN)) {
                fullDetail.configuration = sw.toString();
                fullDetail.storageType = configuration.memory().storage();
                fullDetail.maxSize = configuration.memory().maxSize();
                fullDetail.maxSizeBytes = configuration.memory().maxSizeBytes();
            }
        } else {
            authorizationManager.doIf(request.getSubject(), AuthorizationPermission.ADMIN, () -> {
                fullDetail.configuration = sw.toString();
                fullDetail.storageType = configuration.memory().storage();
                fullDetail.maxSize = configuration.memory().maxSize();
                fullDetail.maxSizeBytes = configuration.memory().maxSizeBytes();
            });
        }
        fullDetail.size = size;
        fullDetail.rehashInProgress = rehashInProgress;
        fullDetail.indexingInProgress = indexingInProgress;
        fullDetail.persistent = persistenceManager.isEnabled();
        fullDetail.bounded = configuration.memory().whenFull().isEnabled();
        fullDetail.indexed = indexed;
        fullDetail.hasRemoteBackup = configuration.sites().hasBackups();
        fullDetail.secured = configuration.security().authorization().enabled();
        fullDetail.transactional = configuration.transaction().transactionMode().isTransactional();
        fullDetail.statistics = statistics;
        fullDetail.queryable = queryable;
        fullDetail.rebalancingEnabled = rebalancingEnabled;
        fullDetail.keyStorage = cache.getAdvancedCache().getKeyDataConversion().getStorageMediaType();
        fullDetail.valueStorage = cache.getAdvancedCache().getValueDataConversion().getStorageMediaType();
        fullDetail.mode = configuration.clustering().cacheModeString();
        return ResourceUtil.addEntityAsJson(fullDetail.toJson(), this.invocationHelper.newResponse(request), pretty).build();
    }

    private boolean reindexingInProgress(Cache<?, ?> cache) {
        SearchStatsRetriever searchStatsRetriever = ComponentRegistryUtils.getSearchStatsRetriever(cache);
        if (searchStatsRetriever != null || !this.internalCacheRegistry.isInternalCache(cache.getName())) {
            return searchStatsRetriever.getSearchStatistics().getIndexStatistics().reindexing();
        }
        return false;
    }

    private CompletionStage<RestResponse> getCacheConfig(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        boolean pretty = Boolean.parseBoolean(request.getParameter("pretty"));
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML);
        responseBuilder.contentType(accept);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager((AdvancedCache)cache.getAdvancedCache());
        if (authorizationManager == null || authorizationManager.isPermissive()) {
            this.invocationHelper.getRestCacheManager().getAuthorizer().checkPermission(AuthorizationPermission.ADMIN);
        }
        Configuration cacheConfiguration = cache.getCacheConfiguration();
        ByteArrayOutputStream entity = new ByteArrayOutputStream();
        try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)entity).withType(accept).prettyPrint(pretty).build();){
            this.parserRegistry.serialize(writer, cacheName, cacheConfiguration);
        }
        catch (Exception e) {
            throw Util.unchecked((Throwable)e);
        }
        responseBuilder.entity(entity);
        return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> getCacheAvailability(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().isRunning(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getInstance().getCache(cacheName).getAdvancedCache();
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AvailabilityMode availability = cache.getAvailability();
        return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).entity(availability).contentType(MediaType.TEXT_PLAIN).status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> setCacheAvailability(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String availability = request.getParameter("availability");
        if (!this.invocationHelper.getRestCacheManager().getInstance().isRunning(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getInstance().getCache(cacheName).getAdvancedCache();
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        try {
            AvailabilityMode availabilityMode = AvailabilityMode.valueOf((String)availability.toUpperCase());
            cache.setAvailability(availabilityMode);
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build());
        }
        catch (IllegalArgumentException e) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.BAD_REQUEST, String.format("Unknown AvailabilityMode '%s'", availability)).toFuture();
        }
    }

    private CompletionStage<RestResponse> getCacheConfigMutableAttributes(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String cacheName = request.variables().get("cacheName");
        boolean full = Boolean.parseBoolean(request.getParameter("full"));
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration((AdvancedCache)cache.getAdvancedCache());
        LinkedHashMap<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        CacheResourceV2.mutableAttributes(cacheConfiguration, attributes, null);
        if (full) {
            Json all = Json.object();
            for (Map.Entry entry : attributes.entrySet()) {
                Attribute attribute = (Attribute)entry.getValue();
                Class type = attribute.getAttributeDefinition().getType();
                Json object = Json.object((Object[])new Object[]{"value", attribute.get(), "type", type.getSimpleName().toLowerCase()});
                if (type.isEnum()) {
                    object.set("universe", Arrays.stream(type.getEnumConstants()).map(Object::toString).collect(Collectors.toList()));
                }
                all.set((String)entry.getKey(), object);
            }
            return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), all, ResourceUtil.isPretty(request));
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(attributes.keySet()), ResourceUtil.isPretty(request));
    }

    private static void mutableAttributes(ConfigurationElement<?> element, Map<String, Attribute> attributes, String prefix) {
        prefix = prefix == null ? "" : (((String)prefix).isEmpty() ? element.elementName() : (String)prefix + "." + element.elementName());
        for (Attribute attribute : element.attributes().attributes()) {
            AttributeDefinition definition;
            if (attribute.isImmutable() || AbstractTypedPropertiesConfiguration.PROPERTIES.equals((Object)(definition = attribute.getAttributeDefinition()))) continue;
            attributes.put((String)prefix + "." + definition.name(), attribute);
        }
        for (ConfigurationElement child : element.children()) {
            CacheResourceV2.mutableAttributes(child, attributes, (String)prefix);
        }
    }

    private CompletionStage<RestResponse> getCacheConfigMutableAttribute(RestRequest request) {
        String attributeName = request.getParameter("attribute-name");
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration((AdvancedCache)cache.getAdvancedCache());
        Attribute attribute = cacheConfiguration.findAttribute(attributeName);
        if (attribute.isImmutable()) {
            throw Log.REST.immutableAttribute(attributeName);
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)String.valueOf(attribute.get())), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> setCacheConfigMutableAttribute(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        String attributeName = request.getParameter("attribute-name");
        String attributeValue = request.getParameter("attribute-value");
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        Configuration configuration = new ConfigurationBuilder().read(SecurityActions.getCacheConfiguration((AdvancedCache)cache.getAdvancedCache())).build();
        Attribute attribute = configuration.findAttribute(attributeName);
        this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin administration = (EmbeddedCacheManagerAdmin)this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request).withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.UPDATE});
        return CompletableFuture.supplyAsync(() -> {
            attribute.fromString(attributeValue);
            administration.getOrCreateCache(cacheName, configuration);
            responseBuilder.status(HttpResponseStatus.OK);
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getSize(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        boolean pretty = ResourceUtil.isPretty(request);
        return cache.sizeAsync().thenApply(size -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.make((Object)size), pretty));
    }

    private CompletionStage<RestResponse> getCacheNames(RestRequest request) throws RestResponseException {
        Collection<String> cacheNames = this.invocationHelper.getRestCacheManager().getAccessibleCacheNames();
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(cacheNames), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> getCacheHealth(RestRequest request) throws RestResponseException {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, request);
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(cache);
        return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).contentType(MediaType.TEXT_PLAIN).entity(new CacheHealthImpl(cr).getStatus().toString()).status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable, RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
            LocalTopologyManager ltm = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)restCacheManager.getInstance()).getLocalTopologyManager();
            try {
                ltm.setCacheRebalancingEnabled(cacheName, enable);
                builder.status(HttpResponseStatus.NO_CONTENT);
            }
            catch (Exception e) {
                throw Util.unchecked((Throwable)e);
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> reinitializeCache(RestRequest request) {
        boolean force = Boolean.parseBoolean(request.getParameter("force"));
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        EmbeddedCacheManager ecm = this.invocationHelper.getProtocolServer().getCacheManager();
        if (!ecm.isCoordinator()) {
            builder.status(HttpResponseStatus.BAD_REQUEST);
            builder.entity(Json.make((Object)("Node not coordinator, request at " + String.valueOf(ecm.getCoordinator()))));
            return CompletableFuture.completedFuture(builder.build());
        }
        GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm);
        ClusterTopologyManager ctm = gcr.getClusterTopologyManager();
        LocalTopologyManager ltm = gcr.getLocalTopologyManager();
        if (ctm == null || ltm == null) {
            builder.status(HttpResponseStatus.BAD_REQUEST);
            return CompletableFuture.completedFuture(builder.build());
        }
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cache = request.variables().get("cacheName");
        InternalCacheRegistry internalRegistry = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class);
        if (ecm.isRunning(cache)) {
            return CompletableFuture.completedFuture(builder.build());
        }
        if (internalRegistry.isInternalCache(cache)) {
            return CompletableFuture.completedFuture(builder.build());
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            if (!ctm.useCurrentTopologyAsStable(cache, force)) {
                return CompletableFuture.completedFuture(builder.build());
            }
            return ltm.stableTopologyCompletion(cache).thenApply(ignore -> builder.build());
        }, this.invocationHelper.getExecutor()).thenCompose(Function.identity())).thenApply(Function.identity());
    }

    private CompletionStage<RestResponse> getCacheNamesPerRole(RestRequest request) throws RestResponseException {
        String roleName = request.getParameter("role");
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (roleName == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        GlobalAuthorizationConfiguration authorization = this.invocationHelper.getRestCacheManager().getInstance().getCacheManagerConfiguration().security().authorization();
        Role role = authorization.getRole(roleName);
        if (role == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        HashSet<String> cachesNames = new HashSet<String>(this.invocationHelper.getRestCacheManager().getAccessibleCacheNames());
        cachesNames.removeAll(this.internalCacheRegistry.getInternalCacheNames());
        HashSet securedCaches = new HashSet();
        HashSet nonSecuredCaches = new HashSet();
        cachesNames.stream().forEach(cacheName -> {
            try {
                AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache((String)cacheName, request);
                SecurityConfiguration config = cache.getCacheConfiguration().security();
                if (config.authorization().enabled() && config.authorization().roles().contains(roleName)) {
                    securedCaches.add(cacheName);
                } else if (!config.authorization().enabled()) {
                    nonSecuredCaches.add(cacheName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Json json = Json.object();
        json.set("secured", Json.make(securedCaches));
        json.set("non-secured", Json.make(nonSecuredCaches));
        return ResourceUtil.asJsonResponseFuture(builder, Json.make((Object)json), ResourceUtil.isPretty(request));
    }

    static class CacheInfo
    implements JsonSerialization {
        public String status;
        public String name;
        public String type;
        public boolean simpleCache;
        public boolean transactional;
        public boolean persistent;
        public boolean bounded;
        public boolean indexed;
        public boolean secured;
        public boolean hasRemoteBackup;
        public HealthStatus health;
        public Boolean rebalancing_enabled;

        CacheInfo() {
        }

        public Json toJson() {
            Json payload = Json.object().set("status", (Object)this.status).set("name", (Object)this.name).set("type", (Object)this.type).set("simple_cache", (Object)this.simpleCache).set("transactional", (Object)this.transactional).set("persistent", (Object)this.persistent).set("bounded", (Object)this.bounded).set("secured", (Object)this.secured).set("indexed", (Object)this.indexed).set("has_remote_backup", (Object)this.hasRemoteBackup).set("health", (Object)this.health);
            if (this.rebalancing_enabled != null) {
                payload.set("rebalancing_enabled", (Object)this.rebalancing_enabled);
            }
            return payload;
        }
    }

    @Listener(clustered=true, includeCurrentState=true)
    public static class StatefulCacheListener
    extends BaseCacheListener {
        public StatefulCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    @Listener(clustered=true)
    public static class StatelessCacheListener
    extends BaseCacheListener {
        public StatelessCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    public static abstract class BaseCacheListener {
        protected final Cache<?, ?> cache;
        protected final EventStream eventStream;

        protected BaseCacheListener(Cache<?, ?> cache) {
            this.cache = cache;
            this.eventStream = new EventStream(null, () -> cache.removeListenerAsync((Object)this));
        }

        public EventStream getEventStream() {
            return this.eventStream;
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryExpired
        public CompletionStage<Void> onCacheEvent(CacheEntryEvent<?, ?> event) {
            ServerSentEvent sse = new ServerSentEvent(event.getType().name().toLowerCase().replace('_', '-'), new String((byte[])event.getKey()));
            return this.eventStream.sendEvent(sse);
        }
    }

    private static class CacheFullDetail
    implements JsonSerialization {
        public Stats stats;
        public Integer size;
        public String configuration;
        public Boolean rehashInProgress;
        public boolean bounded;
        public boolean indexed;
        public boolean persistent;
        public boolean transactional;
        public boolean secured;
        public boolean hasRemoteBackup;
        public Boolean indexingInProgress;
        public boolean statistics;
        public Boolean queryable;
        public Boolean rebalancingEnabled;
        public MediaType keyStorage;
        public MediaType valueStorage;
        public String mode;
        public StorageType storageType;
        public String maxSize;
        public long maxSizeBytes;

        private CacheFullDetail() {
        }

        public Json toJson() {
            Json json = Json.object();
            if (this.stats != null) {
                json.set("stats", this.stats.toJson());
            }
            if (this.size != null) {
                json.set("size", (Object)this.size);
            }
            if (this.rehashInProgress != null) {
                json.set("rehash_in_progress", (Object)this.rehashInProgress);
            }
            if (this.indexingInProgress != null) {
                json.set("indexing_in_progress", (Object)this.indexingInProgress);
            }
            if (this.queryable != null) {
                json.set("queryable", (Object)this.queryable);
            }
            if (this.rebalancingEnabled != null) {
                json.set("rebalancing_enabled", (Object)this.rebalancingEnabled);
            }
            if (this.configuration != null) {
                json.set("configuration", Json.factory().raw(this.configuration));
            }
            if (this.storageType != null) {
                json.set("storage_type", (Object)this.storageType).set("max_size", (Object)(this.maxSize == null ? "" : this.maxSize)).set("max_size_bytes", (Object)this.maxSizeBytes);
            }
            return json.set("bounded", (Object)this.bounded).set("indexed", (Object)this.indexed).set("persistent", (Object)this.persistent).set("transactional", (Object)this.transactional).set("secured", (Object)this.secured).set("has_remote_backup", (Object)this.hasRemoteBackup).set("statistics", (Object)this.statistics).set("key_storage", (Object)this.keyStorage).set("value_storage", (Object)this.valueStorage).set("mode", (Object)this.mode);
        }
    }
}

