/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.distribution.CompleteKeyDistribution;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.operations.CacheOperationsHelper;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.resources.CacheResourceQueryAction;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.telemetry.InfinispanSpan;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.telemetry.InfinispanSpanContext;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.telemetry.SafeAutoClosable;

public class BaseCacheResource {
    private static final MurmurHash3 hashFunc = MurmurHash3.getInstance();
    final CacheResourceQueryAction queryAction;
    final InvocationHelper invocationHelper;
    private final InfinispanTelemetry telemetryService;

    public BaseCacheResource(InvocationHelper invocationHelper, InfinispanTelemetry telemetryService) {
        this.invocationHelper = invocationHelper;
        this.queryAction = new CacheResourceQueryAction(invocationHelper);
        this.telemetryService = telemetryService;
    }

    CompletionStage<RestResponse> deleteCacheValue(RestRequest request) throws RestResponseException {
        String cacheName = request.variables().get("cacheName");
        Object key = this.getKey(request);
        MediaType keyContentType = request.keyContentType();
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, keyContentType, MediaType.MATCH_ALL, request);
        InfinispanSpanAttributes attributes = restCacheManager.getInfinispanSpanAttributes(cacheName, request);
        InfinispanSpan span = this.requestStart("deleteCacheValue", attributes, request);
        try (SafeAutoClosable ignored = span.makeCurrent();){
            CompletionStage<RestResponse> response = restCacheManager.getPrivilegedInternalEntry(cache, key, true).thenCompose(entry -> {
                NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
                responseBuilder.status(HttpResponseStatus.NOT_FOUND);
                if (entry instanceof InternalCacheEntry) {
                    InternalCacheEntry ice = (InternalCacheEntry)entry;
                    String etag = this.calcETAG(ice.getValue());
                    String clientEtag = request.getEtagIfNoneMatchHeader();
                    if (clientEtag == null || clientEtag.equals(etag)) {
                        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
                        return restCacheManager.remove(cacheName, key, keyContentType, request).thenApply(v -> responseBuilder.build());
                    }
                    responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED);
                }
                return CompletableFuture.completedFuture(responseBuilder.build());
            });
            response.whenComplete((BiConsumer<RestResponse, Throwable>)span);
            CompletionStage<RestResponse> completionStage = response;
            return completionStage;
        }
    }

    CompletionStage<RestResponse> putValueToCache(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        MediaType contentType = request.contentType();
        MediaType keyContentType = request.keyContentType();
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, keyContentType, contentType, request);
        InfinispanSpanAttributes attributes = restCacheManager.getInfinispanSpanAttributes(cacheName, request);
        InfinispanSpan span = this.requestStart("putValueToCache", attributes, request);
        try (SafeAutoClosable ignored = span.makeCurrent();){
            Object key = this.getKey(request);
            NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT);
            ContentSource contents = request.contents();
            if (contents == null) {
                throw new NoDataFoundException();
            }
            Long ttl = request.getTimeToLiveSecondsHeader();
            Long idle = request.getMaxIdleTimeSecondsHeader();
            byte[] data = request.contents().rawContent();
            CompletionStage<RestResponse> response = restCacheManager.getPrivilegedInternalEntry(cache, key, true).thenCompose(entry -> {
                if (request.method() == Method.POST && entry != null) {
                    return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.CONFLICT).entity("An entry already exists").build());
                }
                if (entry instanceof InternalCacheEntry) {
                    String etag;
                    InternalCacheEntry ice = (InternalCacheEntry)entry;
                    String etagNoneMatch = request.getEtagIfNoneMatchHeader();
                    if (etagNoneMatch != null && etagNoneMatch.equals(etag = this.calcETAG(ice.getValue()))) {
                        responseBuilder.status(HttpResponseStatus.NOT_MODIFIED);
                        return CompletableFuture.completedFuture(responseBuilder.build());
                    }
                }
                return this.putInCache(responseBuilder, cache, key, data, ttl, idle);
            });
            response.whenComplete((BiConsumer<RestResponse, Throwable>)span);
            CompletionStage<RestResponse> completionStage = response;
            return completionStage;
        }
    }

    CompletionStage<RestResponse> clearEntireCache(RestRequest request) throws RestResponseException {
        String cacheName = request.variables().get("cacheName");
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        InfinispanSpanAttributes attributes = this.invocationHelper.getRestCacheManager().getInfinispanSpanAttributes(cacheName, request);
        InfinispanSpan span = this.requestStart("clearEntireCache", attributes, request);
        try (SafeAutoClosable ignored = span.makeCurrent();){
            CompletionStage response = cache.clearAsync().thenApply(v -> responseBuilder.build());
            ((CompletableFuture)response).whenComplete((BiConsumer)span);
            CompletionStage completionStage = response;
            return completionStage;
        }
    }

    CompletionStage<RestResponse> getCacheValue(RestRequest request) throws RestResponseException {
        String cacheName = request.variables().get("cacheName");
        MediaType keyContentType = request.keyContentType();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        MediaType requestedMediaType = MediaTypeUtils.negotiateMediaType(cache, this.invocationHelper.getEncoderRegistry(), request);
        Object key = this.getKey(request);
        String cacheControl = request.getCacheControlHeader();
        boolean returnBody = request.method() == Method.GET;
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        return restCacheManager.getInternalEntry(cacheName, key, keyContentType, requestedMediaType, request).thenApply(entry -> {
            NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                OptionalInt minFreshSeconds;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Long lastMod = CacheOperationsHelper.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                if (CacheOperationsHelper.entryFreshEnough(expires, minFreshSeconds = CacheOperationsHelper.minFresh(cacheControl))) {
                    Metadata meta = ice.getMetadata();
                    String etag = this.calcETAG(ice.getValue());
                    String ifNoneMatch = request.getEtagIfNoneMatchHeader();
                    String ifMatch = request.getEtagIfMatchHeader();
                    String ifUnmodifiedSince = request.getIfUnmodifiedSinceHeader();
                    String ifModifiedSince = request.getIfModifiedSinceHeader();
                    if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
                        return responseBuilder.status(HttpResponseStatus.NOT_MODIFIED).build();
                    }
                    if (ifMatch != null && !ifMatch.equals(etag)) {
                        return responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED).build();
                    }
                    if (DateUtils.ifUnmodifiedIsBeforeModificationDate(ifUnmodifiedSince, lastMod)) {
                        return responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED).build();
                    }
                    if (DateUtils.isNotModifiedSince(ifModifiedSince, lastMod)) {
                        return responseBuilder.status(HttpResponseStatus.NOT_MODIFIED).build();
                    }
                    Object value = ice.getValue();
                    MediaType configuredMediaType = restCacheManager.getValueConfiguredFormat(cacheName, request);
                    this.writeValue(value, requestedMediaType, configuredMediaType, responseBuilder, returnBody);
                    responseBuilder.status(HttpResponseStatus.OK).lastModified(lastMod).eTag(etag).cacheControl(CacheOperationsHelper.calcCacheControl(expires)).expires(expires).timeToLive(meta.lifespan()).maxIdle(meta.maxIdle()).created(ice.getCreated()).lastUsed(ice.getLastUsed());
                    List<String> extended = request.parameters().get(RequestHeader.EXTENDED_HEADER.getValue());
                    RestServerConfiguration restServerConfiguration = this.invocationHelper.getConfiguration();
                    if (extended != null && !extended.isEmpty() && CacheOperationsHelper.supportsExtendedHeaders(restServerConfiguration, extended.iterator().next())) {
                        responseBuilder.clusterPrimaryOwner(restCacheManager.getPrimaryOwner(cacheName, key, request)).clusterBackupOwners(restCacheManager.getBackupOwners(cacheName, key, request)).clusterNodeName(restCacheManager.getNodeName()).clusterServerAddress(restCacheManager.getServerAddress());
                    }
                }
            }
            return responseBuilder.build();
        });
    }

    protected CompletionStage<CompleteKeyDistribution> keyDistribution(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        Object key = this.getKey(request);
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        return restCacheManager.getKeyDistribution(cacheName, key, request);
    }

    private Object getKey(RestRequest request) {
        String keyRequest = request.variables().get("cacheKey");
        if (keyRequest == null) {
            throw new NoKeyException();
        }
        return keyRequest.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void writeValue(Object value, MediaType requested, MediaType configuredMediaType, NettyRestResponse.Builder responseBuilder, boolean returnBody) {
        MediaType responseContentType = !requested.matchesAll() ? requested : (configuredMediaType == null ? (value instanceof byte[] ? MediaType.APPLICATION_OCTET_STREAM : MediaType.TEXT_PLAIN) : configuredMediaType);
        responseBuilder.contentType(responseContentType);
        if (returnBody) {
            responseBuilder.entity(value);
        }
    }

    private <V> String calcETAG(V value) {
        return String.valueOf(hashFunc.hash(value));
    }

    private CompletionStage<RestResponse> putInCache(NettyRestResponse.Builder responseBuilder, AdvancedCache<Object, Object> cache, Object key, byte[] data, Long ttl, Long idleTime) {
        Configuration config = SecurityActions.getCacheConfiguration(cache);
        Metadata metadata = CacheOperationsHelper.createMetadata(config, ttl, idleTime);
        responseBuilder.header("etag", this.calcETAG(data));
        CompletionStage stage = config.indexing().enabled() ? CompletableFuture.supplyAsync(() -> cache.putAsync(key, (Object)data, metadata), this.invocationHelper.getExecutor()).thenCompose(Function.identity()) : cache.putAsync(key, (Object)data, metadata);
        return stage.thenApply(o -> responseBuilder.build());
    }

    private <T> InfinispanSpan<T> requestStart(String operationName, InfinispanSpanAttributes attributes, RestRequest request) {
        return this.telemetryService.startTraceRequest(operationName, attributes, (InfinispanSpanContext)request);
    }
}

