/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.singleport.SecurityActions;
import org.infinispan.server.router.router.impl.singleport.SinglePortChannelInitializer;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.resp.RespServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;

public class SinglePortEndpointRouter
extends AbstractProtocolServer<SinglePortRouterConfiguration>
implements EndpointRouter {
    private RoutingTable routingTable;

    public SinglePortEndpointRouter(SinglePortRouterConfiguration configuration) {
        super("SinglePort");
        this.configuration = configuration;
    }

    @Override
    public void start(RoutingTable routingTable, EmbeddedCacheManager ecm) {
        this.routingTable = routingTable;
        this.routingTable.streamRoutes().forEach(r -> r.getRouteDestination().getProtocolServer().setEnclosingProtocolServer((ProtocolServer)this));
        this.cacheManager = ecm;
        InetSocketAddress address = new InetSocketAddress(((SinglePortRouterConfiguration)this.configuration).host(), ((SinglePortRouterConfiguration)this.configuration).port());
        this.transport = new NettyTransport(address, this.configuration, this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        if (this.cacheManager != null) {
            BasicComponentRegistry bcr = (BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry(this.cacheManager).getComponent(BasicComponentRegistry.class);
            bcr.replaceComponent(this.getQualifiedName(), (Object)this, false);
        }
        this.registerServerMBeans();
        try {
            this.transport.start();
        }
        catch (Throwable re) {
            try {
                this.unregisterServerMBeans();
            }
            catch (Exception e) {
                re.addSuppressed(e);
            }
            throw re;
        }
        this.registerMetrics();
        RouterLogger.SERVER.debugf("REST EndpointRouter listening on %s:%d", this.transport.getHostName(), this.transport.getPort());
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public InetAddress getIp() {
        try {
            return InetAddress.getByName(this.getHost());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unknown host", e);
        }
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> true;
    }

    public ChannelInitializer<Channel> getInitializer() {
        HashMap upgradeServers = new HashMap();
        RestServer restServer = this.routingTable.streamRoutes(SinglePortRouteSource.class, RestServerRouteDestination.class).findFirst().map(r -> ((RestServerRouteDestination)r.getRouteDestination()).getProtocolServer()).orElseThrow(() -> new IllegalStateException("There must be a REST route!"));
        this.routingTable.streamRoutes(SinglePortRouteSource.class, HotRodServerRouteDestination.class).findFirst().ifPresent(r -> upgradeServers.put("HR", (ProtocolServer<?>)((HotRodServerRouteDestination)r.getRouteDestination()).getProtocolServer()));
        this.routingTable.streamRoutes(SinglePortRouteSource.class, RespServerRouteDestination.class).findFirst().ifPresent(r -> upgradeServers.put("RP", (ProtocolServer<?>)((RespServerRouteDestination)r.getRouteDestination()).getProtocolServer()));
        SinglePortChannelInitializer restChannelInitializer = new SinglePortChannelInitializer(this, this.transport, restServer, upgradeServers);
        return new NettyInitializers(new NettyInitializer[]{restChannelInitializer});
    }

    @Override
    public EndpointRouter.Protocol getProtocol() {
        return EndpointRouter.Protocol.SINGLE_PORT;
    }
}

