/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.ArrayList;
import java.util.Map;
import org.infinispan.rest.ALPNHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;

class SinglePortChannelInitializer
extends NettyChannelInitializer<SinglePortRouterConfiguration> {
    private final RestServer restServer;
    private final Map<String, ProtocolServer<?>> upgradeServers;

    public SinglePortChannelInitializer(SinglePortEndpointRouter server, NettyTransport transport, RestServer restServer, Map<String, ProtocolServer<?>> upgradeServers) {
        super((ProtocolServer)server, transport, null, null, SinglePortChannelInitializer.getAlpnConfiguration(server, upgradeServers));
        this.restServer = restServer;
        this.upgradeServers = upgradeServers;
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        for (ProtocolServer<?> ps : this.upgradeServers.values()) {
            ps.installDetector(ch);
        }
        if (((SinglePortRouterConfiguration)this.server.getConfiguration()).ssl().enabled()) {
            ch.pipeline().addLast(new ChannelHandler[]{new ALPNHandler(this.restServer)});
        } else {
            ALPNHandler.configurePipeline((ChannelPipeline)ch.pipeline(), (String)"http/1.1", (RestServer)this.restServer, this.upgradeServers);
        }
    }

    private static ApplicationProtocolConfig getAlpnConfiguration(SinglePortEndpointRouter server, Map<String, ProtocolServer<?>> upgradeServers) {
        if (((SinglePortRouterConfiguration)server.getConfiguration()).ssl().enabled()) {
            ArrayList<String> supportedProtocols = new ArrayList<String>();
            supportedProtocols.add("h2");
            supportedProtocols.add("http/1.1");
            supportedProtocols.addAll(upgradeServers.keySet());
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
        }
        return null;
    }
}

