/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)org.infinispan.security.Security.doPrivileged(action);
    }

    static void addSecurityProvider(Provider provider) {
        SecurityActions.doPrivileged(() -> {
            if (Security.getProvider(provider.getName()) == null) {
                Security.insertProviderAt(provider, 1);
            }
            return null;
        });
    }
}

