/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.server.tasks.DistributedServerTask;
import org.infinispan.server.tasks.SecurityActions;
import org.infinispan.server.tasks.ServerTaskRunner;
import org.infinispan.server.tasks.TaskParameter;
import org.infinispan.tasks.TaskContext;
import org.infinispan.util.function.TriConsumer;

public class DistributedServerTaskRunner
implements ServerTaskRunner {
    @Override
    public <T> CompletableFuture<T> execute(String taskName, TaskContext context) {
        Cache masterCacheNode = (Cache)context.getCache().get();
        ClusterExecutor clusterExecutor = SecurityActions.getClusterExecutor(context.getCacheManager());
        List results = Collections.synchronizedList(new ArrayList());
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            results.add(v);
        };
        List<TaskParameter> taskParams = context.getParameters().orElse(Collections.emptyMap()).entrySet().stream().map(e -> new TaskParameter((String)e.getKey(), e.getValue().toString())).collect(Collectors.toList());
        CompletableFuture future = clusterExecutor.submitConsumer(new DistributedServerTask(taskName, masterCacheNode.getName(), taskParams), triConsumer);
        return future.thenApply(ignore -> results);
    }
}

