/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;

public class EndpointsConfiguration {
    static final AttributeDefinition<String> SOCKET_BINDING = AttributeDefinition.builder((Enum)Attribute.SOCKET_BINDING, null, String.class).build();
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((Enum)Attribute.SECURITY_REALM, null, String.class).build();
    private final List<EndpointConfiguration> endpoints;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EndpointsConfiguration.class, new AttributeDefinition[]{SOCKET_BINDING, SECURITY_REALM});
    }

    EndpointsConfiguration(AttributeSet attributes, List<EndpointConfiguration> endpoints) {
        this.attributes = attributes.checkProtection();
        this.endpoints = endpoints;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(SECURITY_REALM).get();
    }

    public String socketBinding() {
        return (String)this.attributes.attribute(SOCKET_BINDING).get();
    }

    public List<EndpointConfiguration> endpoints() {
        return this.endpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointsConfiguration that = (EndpointsConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "EndpointConfiguration{attributes=" + this.attributes + "}";
    }
}

