/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Properties;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.realm.ldap.SimpleDirContextFactoryBuilder;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.source.CredentialSource;

@BuiltBy(value=LdapRealmConfigurationBuilder.class)
public class LdapRealmConfiguration
extends ConfigurationElement<LdapRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<Supplier<CredentialSource>> CREDENTIAL = AttributeDefinition.builder((Enum)Attribute.CREDENTIAL, null, char[].class).serializer(ServerConfigurationSerializer.CREDENTIAL).immutable().build();
    static final AttributeDefinition<Boolean> DIRECT_EVIDENCE_VERIFICATION = AttributeDefinition.builder((Enum)Attribute.DIRECT_VERIFICATION, null, Boolean.class).immutable().build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"ldap", String.class).immutable().build();
    static final AttributeDefinition<NameRewriter> NAME_REWRITER = AttributeDefinition.builder((Enum)Element.NAME_REWRITER, null, NameRewriter.class).autoPersist(false).immutable().build();
    static final AttributeDefinition<String> PRINCIPAL = AttributeDefinition.builder((Enum)Attribute.PRINCIPAL, null, String.class).immutable().build();
    static final AttributeDefinition<Integer> PAGE_SIZE = AttributeDefinition.builder((Enum)Attribute.PAGE_SIZE, (Object)50, Integer.class).immutable().build();
    static final AttributeDefinition<String> URL = AttributeDefinition.builder((Enum)Attribute.URL, null, String.class).immutable().build();
    static final AttributeDefinition<Integer> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECTION_TIMEOUT, (Object)5000, Integer.class).immutable().build();
    static final AttributeDefinition<Integer> READ_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.READ_TIMEOUT, (Object)60000, Integer.class).immutable().build();
    static final AttributeDefinition<Boolean> CONNECTION_POOLING = AttributeDefinition.builder((Enum)Attribute.CONNECTION_POOLING, (Object)false, Boolean.class).immutable().build();
    static final AttributeDefinition<DirContextFactory.ReferralMode> REFERRAL_MODE = AttributeDefinition.builder((Enum)Attribute.REFERRAL_MODE, (Object)DirContextFactory.ReferralMode.IGNORE, DirContextFactory.ReferralMode.class).immutable().build();
    static final AttributeDefinition<String> CLIENT_SSL_CONTEXT = AttributeDefinition.builder((Enum)Attribute.CLIENT_SSL_CONTEXT, null, String.class).immutable().build();
    private final LdapIdentityMappingConfiguration identityMapping;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapRealmConfiguration.class, new AttributeDefinition[]{DIRECT_EVIDENCE_VERIFICATION, NAME, NAME_REWRITER, PRINCIPAL, PAGE_SIZE, URL, CONNECTION_TIMEOUT, READ_TIMEOUT, CONNECTION_POOLING, REFERRAL_MODE, CLIENT_SSL_CONTEXT, CREDENTIAL});
    }

    LdapRealmConfiguration(AttributeSet attributes, LdapIdentityMappingConfiguration identityMapping) {
        super((Enum)Element.LDAP_REALM, attributes, new ConfigurationElement[0]);
        this.identityMapping = identityMapping;
    }

    public LdapIdentityMappingConfiguration identityMapping() {
        return this.identityMapping;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public NameRewriter nameRewriter() {
        return (NameRewriter)this.attributes.attribute(NAME_REWRITER).get();
    }

    @Override
    public SecurityRealm build(SecurityConfiguration security, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        LdapSecurityRealmBuilder ldapRealmBuilder = LdapSecurityRealmBuilder.builder();
        this.attributes.attribute(DIRECT_EVIDENCE_VERIFICATION).apply(arg_0 -> ((LdapSecurityRealmBuilder)ldapRealmBuilder).addDirectEvidenceVerification(arg_0));
        ldapRealmBuilder.setPageSize(((Integer)this.attributes.attribute(PAGE_SIZE).get()).intValue());
        this.identityMapping.build(ldapRealmBuilder, realm);
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("com.sun.jndi.ldap.connect.pool", ((Boolean)this.attributes.attribute(CONNECTION_POOLING).get()).toString());
        SimpleDirContextFactoryBuilder dirContextBuilder = SimpleDirContextFactoryBuilder.builder();
        dirContextBuilder.setProviderUrl((String)this.attributes.attribute(URL).get());
        dirContextBuilder.setSecurityPrincipal((String)this.attributes.attribute(PRINCIPAL).get());
        dirContextBuilder.setCredentialSource((CredentialSource)((Supplier)this.attributes.attribute(CREDENTIAL).get()).get());
        dirContextBuilder.setConnectTimeout(((Integer)this.attributes.attribute(CONNECTION_TIMEOUT).get()).intValue()).setReadTimeout(((Integer)this.attributes.attribute(READ_TIMEOUT).get()).intValue());
        dirContextBuilder.setConnectionProperties(connectionProperties);
        this.attributes.attribute(CLIENT_SSL_CONTEXT).apply(v -> dirContextBuilder.setSocketFactory((SocketFactory)security.realms().getRealm((String)v).clientSSLContext().getSocketFactory()));
        DirContextFactory dirContextFactory = dirContextBuilder.build();
        ldapRealmBuilder.setDirContextSupplier(() -> dirContextFactory.obtainDirContext((DirContextFactory.ReferralMode)this.attributes.attribute(REFERRAL_MODE).get()));
        if (this.attributes.attribute(NAME_REWRITER).isModified()) {
            ldapRealmBuilder.setNameRewriter((NameRewriter)this.attributes.attribute(NAME_REWRITER).get());
        }
        realm.addFeature(ServerSecurityRealm.Feature.PASSWORD_PLAIN);
        return ldapRealmBuilder.build();
    }
}

