/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfiguration;

public class SocketBindingsConfigurationBuilder
implements Builder<SocketBindingsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private Map<String, SocketBindingConfigurationBuilder> socketBindings = new LinkedHashMap<String, SocketBindingConfigurationBuilder>(2);

    SocketBindingsConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = SocketBindingsConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    SocketBindingsConfigurationBuilder socketBinding(String name, int port, String interfaceName) {
        SocketBindingConfigurationBuilder configurationBuilder = new SocketBindingConfigurationBuilder(this.server);
        configurationBuilder.binding(name, port, interfaceName);
        this.socketBindings.put(name, configurationBuilder);
        return this;
    }

    public SocketBindingsConfigurationBuilder offset(Integer offset) {
        this.attributes.attribute(SocketBindingsConfiguration.PORT_OFFSET).set((Object)offset);
        return this;
    }

    public Integer offset() {
        return (Integer)this.attributes.attribute(SocketBindingsConfiguration.PORT_OFFSET).get();
    }

    SocketBindingsConfigurationBuilder defaultInterface(String interfaceName) {
        this.attributes.attribute(SocketBindingsConfiguration.DEFAULT_INTERFACE).set((Object)interfaceName);
        return this;
    }

    public SocketBindingsConfiguration create() {
        throw new UnsupportedOperationException();
    }

    public SocketBindingsConfiguration create(InterfacesConfiguration interfaces) {
        HashMap<String, SocketBindingConfiguration> bindings = new HashMap<String, SocketBindingConfiguration>();
        for (Map.Entry<String, SocketBindingConfigurationBuilder> e : this.socketBindings.entrySet()) {
            String name = e.getValue().interfaceName();
            if (!interfaces.exists(name)) {
                throw Server.log.unknownInterface(name);
            }
            bindings.put(e.getKey(), e.getValue().create(interfaces.interfaces().get(name)));
        }
        return new SocketBindingsConfiguration(this.attributes.protect(), bindings);
    }

    public SocketBindingsConfigurationBuilder read(SocketBindingsConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.socketBindings.clear();
        template.socketBindings().forEach((n, s) -> this.socketBinding(s.name(), s.port(), s.interfaceName()));
        return this;
    }

    String defaultInterface() {
        return (String)this.attributes.attribute(SocketBindingsConfiguration.DEFAULT_INTERFACE).get();
    }
}

