/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;

public class LdapIdentityMappingConfiguration
extends ConfigurationElement<LdapIdentityMappingConfiguration> {
    static final AttributeDefinition<String> RDN_IDENTIFIER = AttributeDefinition.builder((Enum)Attribute.RDN_IDENTIFIER, null, String.class).immutable().build();
    static final AttributeDefinition<String> SEARCH_BASE_DN = AttributeDefinition.builder((Enum)Attribute.SEARCH_DN, null, String.class).immutable().build();
    static final AttributeDefinition<Boolean> SEARCH_RECURSIVE = AttributeDefinition.builder((Enum)Attribute.SEARCH_RECURSIVE, (Object)false, Boolean.class).immutable().build();
    static final AttributeDefinition<Integer> SEARCH_TIME_LIMIT = AttributeDefinition.builder((Enum)Attribute.SEARCH_TIME_LIMIT, (Object)10000, Integer.class).immutable().build();
    static final AttributeDefinition<String> FILTER_NAME = AttributeDefinition.builder((Enum)Attribute.FILTER_NAME, (Object)"(rdn_identifier={0})", String.class).immutable().build();
    private final List<LdapAttributeConfiguration> attributeMappings;
    private final LdapUserPasswordMapperConfiguration userPasswordMapper;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapIdentityMappingConfiguration.class, new AttributeDefinition[]{RDN_IDENTIFIER, SEARCH_BASE_DN, SEARCH_RECURSIVE, SEARCH_TIME_LIMIT, FILTER_NAME});
    }

    LdapIdentityMappingConfiguration(AttributeSet attributes, List<LdapAttributeConfiguration> attributeMappings, LdapUserPasswordMapperConfiguration userPasswordMapper) {
        super((Enum)Element.IDENTITY_MAPPING, attributes, new ConfigurationElement[0]);
        this.attributeMappings = attributeMappings;
        this.userPasswordMapper = userPasswordMapper;
    }

    public List<LdapAttributeConfiguration> attributeMappings() {
        return this.attributeMappings;
    }

    public LdapUserPasswordMapperConfiguration userPasswordMapper() {
        return this.userPasswordMapper;
    }

    void build(LdapSecurityRealmBuilder builder, RealmConfiguration realm) {
        LdapSecurityRealmBuilder.IdentityMappingBuilder identity = builder.identityMapping();
        if (this.attributes.attribute(RDN_IDENTIFIER).isModified()) {
            identity.setRdnIdentifier((String)this.attributes.attribute(RDN_IDENTIFIER).get());
        }
        if (this.attributes.attribute(SEARCH_BASE_DN).isModified()) {
            identity.setSearchDn((String)this.attributes.attribute(SEARCH_BASE_DN).get());
        }
        if (((Boolean)this.attributes.attribute(SEARCH_RECURSIVE).get()).booleanValue()) {
            identity.searchRecursive();
        }
        identity.setSearchTimeLimit(((Integer)this.attributes.attribute(SEARCH_TIME_LIMIT).get()).intValue());
        if (this.attributes.attribute(FILTER_NAME).isModified()) {
            identity.setFilterName((String)this.attributes.attribute(FILTER_NAME).get());
        }
        for (LdapAttributeConfiguration mapping : this.attributeMappings) {
            mapping.build(identity);
        }
        this.userPasswordMapper.build(builder, realm);
        identity.build();
    }
}

