/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientXSiteDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanXSiteServerTestMethodRule
implements TestRule,
TestClientXSiteDriver {
    private final Map<String, TestClient> testClients = new HashMap<String, TestClient>();

    public InfinispanXSiteServerTestMethodRule(InfinispanXSiteServerRule serverRule) {
        Objects.requireNonNull(serverRule, "InfinispanServerRule class Rule is null");
        serverRule.getTestServers().forEach(it -> this.testClients.put(it.getSiteName(), new TestClient(it)));
    }

    public String getMethodName() {
        return this.testClients.values().iterator().next().getMethodName();
    }

    public HotRodTestClientDriver hotrod(String siteName) {
        return this.testClients.get(siteName).hotrod();
    }

    public RestTestClientDriver rest(String siteName) {
        return this.testClients.get(siteName).rest();
    }

    public CounterManager getCounterManager(String siteName) {
        return this.testClients.get(siteName).getCounterManager();
    }

    public <K, V> MultimapCacheManager<K, V> getMultimapCacheManager(String siteName) {
        return this.testClients.get(siteName).getRemoteMultimapCacheManager();
    }

    public MemcachedClient getMemcachedClient(String siteName) {
        return this.testClients.get(siteName).getMemcachedClient();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    InfinispanXSiteServerTestMethodRule.this.testClients.values().forEach(testClient -> {
                        testClient.initResources();
                        testClient.setMethodName(description.getTestClass().getSimpleName() + "." + description.getMethodName());
                    });
                    base.evaluate();
                }
                finally {
                    InfinispanXSiteServerTestMethodRule.this.testClients.values().forEach(TestClient::clearResources);
                }
            }
        };
    }

    public String addScript(String siteName, RemoteCacheManager remoteCacheManager, String script) {
        return this.testClients.get(siteName).addScript(remoteCacheManager, script);
    }

    public RestClient newRestClient(String siteName, RestClientConfigurationBuilder restClientConfigurationBuilder) {
        return this.testClients.get(siteName).newRestClient(restClientConfigurationBuilder);
    }
}

