/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoEnumTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AnnotatedClassScanner;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.DangerousActions;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.MarshallerSourceCodeGenerator;
import org.infinispan.protostream.annotations.impl.processor.dependecy.CompileTimeDependency;
import org.infinispan.protostream.annotations.impl.processor.types.MirrorTypeFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;

final class CompileTimeProtoSchemaGenerator
extends BaseProtoSchemaGenerator {
    private final Map<XClass, CompileTimeDependency> dependencies;
    private final MarshallerSourceCodeGenerator marshallerSourceCodeGenerator;
    private final AnnotatedClassScanner classScanner;
    private final Map<XClass, XClass> adapterMap = new HashMap<XClass, XClass>();

    CompileTimeProtoSchemaGenerator(XTypeFactory typeFactory, GeneratedFilesWriter generatedFilesWriter, SerializationContext serializationContext, String generator, String fileName, String packageName, Map<XClass, CompileTimeDependency> dependencies, Set<XClass> classes, boolean autoImportClasses, AnnotatedClassScanner classScanner) {
        super(typeFactory, serializationContext, generator, fileName, packageName, classes, autoImportClasses);
        this.dependencies = dependencies;
        this.marshallerSourceCodeGenerator = new MarshallerSourceCodeGenerator(generatedFilesWriter, typeFactory, packageName);
        this.classScanner = classScanner;
    }

    protected AbstractMarshallerCodeGenerator makeMarshallerCodeGenerator() {
        return this.marshallerSourceCodeGenerator;
    }

    protected ProtoTypeMetadata makeEnumTypeMetadata(XClass javaType) {
        return new ProtoEnumTypeMetadata(javaType, this.getTargetClass(javaType));
    }

    protected ProtoTypeMetadata makeMessageTypeMetadata(XClass javaType) {
        XClass targetClass = this.getTargetClass(javaType);
        if (!targetClass.equals(javaType)) {
            this.adapterMap.put(targetClass, javaType);
        }
        return new CompileTimeProtoMessageTypeMetadata(this, javaType, targetClass);
    }

    protected ProtoTypeMetadata importProtoTypeMetadata(XClass javaType) {
        if (javaType == this.typeFactory.fromClass(WrappedMessage.class)) {
            GenericDescriptor descriptor = this.serializationContext.getDescriptorByName("org.infinispan.protostream.WrappedMessage");
            BaseMarshaller marshaller = this.serializationContext.getMarshaller("org.infinispan.protostream.WrappedMessage");
            return new ImportedProtoTypeMetadata(descriptor, marshaller, javaType);
        }
        CompileTimeDependency dependency = this.dependencies.get(javaType);
        if (dependency != null) {
            String packageName = ((FileDescriptor)this.serializationContext.getFileDescriptors().get(dependency.getFileName())).getPackage();
            return new CompileTimeImportedProtoTypeMetadata(this.makeTypeMetadata(dependency.getUseToMakeTypeMetadata()), packageName, dependency.getFileName());
        }
        return null;
    }

    protected boolean isUnknownClass(XClass c) {
        if (super.isUnknownClass(c) && !this.dependencies.containsKey(c) && !this.classScanner.isClassAcceptable(c)) {
            throw new ProtoSchemaBuilderException("Found a reference to class " + c.getCanonicalName() + " which was not explicitly included by @AutoProtoSchemaBuilder and the combination of relevant attributes (basePackages, includeClasses, excludeClasses, autoImportClasses) do not allow it to be included.");
        }
        return false;
    }

    protected XClass getAdapterFor(XClass annotatedClass) {
        ProtoAdapter protoAdapter;
        try {
            protoAdapter = (ProtoAdapter)annotatedClass.getAnnotation(ProtoAdapter.class);
            if (protoAdapter == null) {
                return null;
            }
        }
        catch (ClassCastException e) {
            throw new ProtoSchemaBuilderException("The class referenced by the ProtoAdapter annotation does not exist, possibly due to compilation errors in your source code or due to incremental compilation issues caused by your build system. Please try a clean rebuild.");
        }
        TypeMirror typeMirror = DangerousActions.getTypeMirror(protoAdapter, ProtoAdapter::value);
        XClass target = ((MirrorTypeFactory)this.typeFactory).fromTypeMirror(typeMirror);
        if (target == annotatedClass) {
            throw new ProtoSchemaBuilderException(annotatedClass.getName() + " has an invalid @ProtoAdapter annotation pointing to self");
        }
        return target;
    }

    public XClass getOriginalClass(XClass targetClass) {
        XClass xClass = this.adapterMap.get(targetClass);
        if (xClass == null) {
            return targetClass;
        }
        return xClass;
    }

    public Set<String> getGeneratedMarshallerClasses() {
        return this.marshallerSourceCodeGenerator.getGeneratedClasses();
    }
}

