/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cache.container;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="off-heap")})
public class OffHeapContainerIT {
    public static final String CONFIG_NAME = "off-heap";
    private static RemoteCacheManager remoteCacheManager;
    @InfinispanResource(value="off-heap")
    RemoteInfinispanServer server1;

    @Before
    public void setUp() {
        if (remoteCacheManager == null) {
            remoteCacheManager = ITestUtils.createCacheManager(this.server1);
        }
    }

    @Test
    public void testBasicOps() {
        RemoteCache rc = remoteCacheManager.getCache("off-heap-bounded");
        rc.clear();
        rc.put((Object)"keyA", (Object)"A");
        rc.put((Object)"keyB", (Object)"B");
        rc.put((Object)"keyC", (Object)"C");
        rc.put((Object)"keyD", (Object)"D");
        Assert.assertEquals((long)3L, (long)rc.size());
        Assert.assertNull((String)"Key A should be evicted from cache", (Object)rc.get((Object)"keyA"));
        Assert.assertEquals((Object)"B", (Object)rc.get((Object)"keyB"));
        Assert.assertEquals((Object)"C", (Object)rc.get((Object)"keyC"));
        Assert.assertEquals((Object)"D", (Object)rc.get((Object)"keyD"));
        Assert.assertFalse((boolean)rc.containsKey((Object)"keyA"));
        Assert.assertTrue((boolean)rc.containsKey((Object)"keyB"));
        rc.replace((Object)"keyB", (Object)"B", (Object)"BB");
        Assert.assertEquals((Object)"BB", (Object)rc.get((Object)"keyB"));
        rc.putIfAbsent((Object)"keyB", (Object)"BBB");
        Assert.assertEquals((Object)"BB", (Object)rc.get((Object)"keyB"));
        rc.putIfAbsent((Object)"keyA", (Object)"AA");
        Assert.assertEquals((Object)"AA", (Object)rc.get((Object)"keyA"));
        MetadataValue meta = rc.getWithMetadata((Object)"keyA");
        Assert.assertTrue((boolean)rc.replaceWithVersion((Object)"keyA", (Object)"AAA", meta.getVersion()));
        Assert.assertEquals((Object)"AAA", (Object)rc.get((Object)"keyA"));
        rc.replace((Object)"keyA", (Object)"AAAA");
        Assert.assertFalse((boolean)rc.replaceWithVersion((Object)"keyA", (Object)"AAA", meta.getVersion()));
        Assert.assertEquals((Object)"AAAA", (Object)rc.get((Object)"keyA"));
        rc.put((Object)"keyA", (Object)"AAAAA", 10L, TimeUnit.MILLISECONDS, 20L, TimeUnit.MILLISECONDS);
        meta = rc.getWithMetadata((Object)"keyA");
        Assert.assertTrue((boolean)rc.containsKey((Object)"keyA"));
        rc.remove((Object)"keyA");
        Assert.assertFalse((boolean)rc.containsKey((Object)"keyA"));
        rc.clear();
        Assert.assertEquals((long)0L, (long)rc.size());
    }

    @Test
    public void testPutAndGetBulk() {
        RemoteCache rc = remoteCacheManager.getCache("off-heap-default");
        rc.clear();
        HashMap values = new HashMap();
        IntStream.range(0, 100).forEach(i -> values.put("key" + i, i));
        rc.putAll(values);
        Assert.assertEquals((long)100L, (long)rc.size());
        CloseableIteratorSet keys = rc.keySet();
        Assert.assertEquals((long)100L, (long)keys.size());
        Assert.assertTrue((boolean)keys.contains("key0"));
        Assert.assertTrue((boolean)keys.contains("key50"));
        Assert.assertTrue((boolean)keys.contains("key99"));
        CloseableIterator iter = rc.retrieveEntries(null, 100);
        HashMap<String, Integer> keyVal = new HashMap<String, Integer>(100);
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            keyVal.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        IntStream.range(0, 100).forEach(i -> {
            Assert.assertTrue((boolean)keyVal.containsKey("key" + i));
            Assert.assertEquals((Object)new Integer(i), keyVal.get("key" + i));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestEndpoint() throws Exception {
        String cacheName = "off-heap-default";
        try (CloseableHttpClient restClient = null;){
            restClient = HttpClients.createDefault();
            RemoteInfinispanMBeans mbean = RemoteInfinispanMBeans.create(this.server1, CONFIG_NAME, cacheName, "local");
            String restUrl = "http://" + mbean.server.getHotrodEndpoint().getInetAddress().getHostName() + ":8080" + mbean.server.getRESTEndpoint().getContextPath() + "/" + cacheName;
            String key = "key";
            byte[] value = "value".getBytes();
            HttpPut put = new HttpPut(restUrl + "/" + key);
            put.setEntity((HttpEntity)new ByteArrayEntity(value, ContentType.APPLICATION_OCTET_STREAM));
            CloseableHttpResponse putResponse = restClient.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)putResponse.getStatusLine().getStatusCode());
            HttpGet get = new HttpGet(restUrl + "/" + key);
            get.addHeader("Accept", ContentType.APPLICATION_OCTET_STREAM.toString());
            CloseableHttpResponse getResponse = restClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)getResponse.getStatusLine().getStatusCode());
            Assert.assertArrayEquals((byte[])value, (byte[])EntityUtils.toByteArray((HttpEntity)getResponse.getEntity()));
        }
    }
}

