/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractRemoteCacheManagerIT {
    private static final String IPV6_REGEX = "\\A\\[(.*)\\]:([0-9]+)\\z";
    private static final String IPV4_REGEX = "\\A([^:]+):([0-9]+)\\z";
    protected static String testCache = "default";
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheManagerIT.class);

    protected abstract List<RemoteInfinispanServer> getServers();

    private ConfigurationBuilder createRemoteCacheManagerConfigurationBuilder() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        this.addServers(config);
        config.balancingStrategy("org.infinispan.server.test.client.hotrod.HotRodTestRequestBalancingStrategy").forceReturnValues(true).tcpNoDelay(false).tcpKeepAlive(true).marshaller("org.infinispan.server.test.client.hotrod.HotRodTestMarshaller").asyncExecutorFactory().factoryClass("org.infinispan.server.test.client.hotrod.HotRodTestExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "20").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "200000").keySizeEstimate(128).valueSizeEstimate(1024);
        return config;
    }

    @Test
    public void testDefaultConstructor() throws Exception {
        Configuration conf = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager();
        RemoteCacheManager rcm2 = new RemoteCacheManager(false);
        Assert.assertTrue((boolean)rcm.isStarted());
        Assert.assertFalse((boolean)rcm2.isStarted());
        RemoteCache rc = rcm.getCache(testCache);
        this.assertEqualConfiguration(conf, rc);
    }

    @Test
    public void testConfigurationConstructors() throws Exception {
        Configuration conf = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(conf);
        RemoteCacheManager rcm2 = new RemoteCacheManager(conf, false);
        Assert.assertTrue((boolean)rcm.isStarted());
        Assert.assertFalse((boolean)rcm2.isStarted());
        RemoteCache rc = rcm.getCache(testCache);
        this.assertEqualConfiguration(conf, rc);
    }

    @Test
    public void testEmptyConfiguration() throws Exception {
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        this.addServers(confBuilder);
        RemoteCacheManager rcm = new RemoteCacheManager(confBuilder.build());
        RemoteCache rc = rcm.getCache(testCache);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.addServers(builder);
        builder.balancingStrategy("org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy").forceReturnValues(false).tcpNoDelay(true).transportFactory("org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory").marshaller("org.infinispan.commons.marshall.jboss.GenericJBossMarshaller").asyncExecutorFactory().factoryClass("org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.pool_size", "10").addExecutorProperty("infinispan.client.hotrod.default_executor_factory.queue_size", "100000").keySizeEstimate(64).valueSizeEstimate(512);
        Configuration defaultConf = builder.build();
        this.assertEqualConfiguration(defaultConf, rc);
    }

    private void addServers(ConfigurationBuilder builder) {
        for (RemoteInfinispanServer server : this.getServers()) {
            builder.addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort());
        }
    }

    @Test
    public void testStartStop() {
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg, false);
        Assert.assertTrue((String)"RemoteCacheManager should not be started initially", (!rcm.isStarted() ? 1 : 0) != 0);
        rcm.start();
        Assert.assertTrue((String)"RemoteCacheManager should be started after calling start()", (boolean)rcm.isStarted());
        rcm.stop();
        Assert.assertTrue((String)"RemoteCacheManager should be stopped after calling stop()", (!rcm.isStarted() ? 1 : 0) != 0);
    }

    @Test
    public void testGetNonExistentCache() {
        RemoteCacheManager rcm = new RemoteCacheManager(this.createRemoteCacheManagerConfigurationBuilder().build());
        RemoteCache rc1 = rcm.getCache("nonExistentCache");
        try {
            for (String stat : rc1.stats().getStatsMap().keySet()) {
                log.tracef(stat + " " + (String)rc1.stats().getStatsMap().get(stat), new Object[0]);
            }
            Assert.fail((String)"Should throw CacheNotFoundException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultLoadBalancing() throws Exception {
        if (!ITestUtils.isLocalMode()) {
            this.doTestDefaultLoadBalanding();
        }
    }

    private void doTestDefaultLoadBalanding() throws Exception {
        InetSocketAddress hostport0 = new InetSocketAddress(this.getServers().get(0).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getHotrodEndpoint().getPort());
        InetSocketAddress hostport1 = new InetSocketAddress(this.getServers().get(1).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getHotrodEndpoint().getPort());
        Channel tt = null;
        InetSocketAddress sock_addr = null;
        StringBuilder serverAddrSequence = new StringBuilder();
        String hostport0String = hostport0.getAddress().getHostAddress() + ":" + hostport0.getPort();
        String hostport1String = hostport1.getAddress().getHostAddress() + ":" + hostport1.getPort();
        String expectedSequence1 = hostport0String + " " + hostport1String + " " + hostport0String;
        String expectedSequence2 = hostport1String + " " + hostport0String + " " + hostport1String;
        String expectedSequenceLocalMode = hostport0String + " " + hostport0String + " " + hostport0String;
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg);
        RemoteCache rc = rcm.getCache(testCache);
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        tt = (Channel)((NoopChannelOperation)ttf.fetchChannelAndInvoke(null, rci.getName().getBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        sock_addr = this.resolve((InetSocketAddress)tt.remoteAddress());
        ttf.releaseChannel(tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress()).append(":").append(sock_addr.getPort()).append(" ");
        tt = (Channel)((NoopChannelOperation)ttf.fetchChannelAndInvoke(null, rci.getName().getBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        sock_addr = this.resolve((InetSocketAddress)tt.remoteAddress());
        ttf.releaseChannel(tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress()).append(":").append(sock_addr.getPort()).append(" ");
        tt = (Channel)((NoopChannelOperation)ttf.fetchChannelAndInvoke(null, rci.getName().getBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        sock_addr = this.resolve((InetSocketAddress)tt.remoteAddress());
        ttf.releaseChannel(tt);
        serverAddrSequence.append(sock_addr.getAddress().getHostAddress()).append(":").append(sock_addr.getPort());
        if (!ITestUtils.isLocalMode()) {
            Assert.assertTrue((String)("loadbalancing server sequence expected either " + expectedSequence1 + " or " + expectedSequence2 + ", actual sequence: " + serverAddrSequence.toString()), (serverAddrSequence.toString().equals(expectedSequence1) || serverAddrSequence.toString().equals(expectedSequence2) ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)("LOCAL mode - loadbalancing server sequence expected " + expectedSequenceLocalMode + ", actual sequence: " + serverAddrSequence.toString()), (Object)serverAddrSequence.toString(), (Object)expectedSequenceLocalMode);
        }
    }

    @Test
    public void testCustomLoadBalancing() throws Exception {
        if (!ITestUtils.isLocalMode()) {
            this.doTestCustomLoadBalancing();
        }
    }

    private void doTestCustomLoadBalancing() throws Exception {
        InetSocketAddress hostport0 = new InetSocketAddress(this.getServers().get(0).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getHotrodEndpoint().getPort());
        InetSocketAddress hostport1 = new InetSocketAddress(this.getServers().get(1).getHotrodEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getHotrodEndpoint().getPort());
        Channel tt = null;
        InetSocketAddress sock_addr = null;
        Configuration cfg = this.createRemoteCacheManagerConfigurationBuilder().balancingStrategy("org.infinispan.server.test.client.hotrod.Node0OnlyBalancingStrategy").build();
        RemoteCacheManager rcm = new RemoteCacheManager(cfg);
        RemoteCache rc = rcm.getCache(testCache);
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        tt = (Channel)((NoopChannelOperation)ttf.fetchChannelAndInvoke(null, rci.getName().getBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        sock_addr = this.resolve((InetSocketAddress)tt.remoteAddress());
        ttf.releaseChannel(tt);
        Assert.assertEquals((String)("load balancing first request: server address expected " + hostport0 + ", actual server address " + sock_addr), (Object)sock_addr, (Object)hostport0);
        tt = (Channel)((NoopChannelOperation)ttf.fetchChannelAndInvoke(null, rci.getName().getBytes(), (ChannelOperation)new NoopChannelOperation())).join();
        sock_addr = this.resolve((InetSocketAddress)tt.remoteAddress());
        ttf.releaseChannel(tt);
        Assert.assertEquals((String)("load balancing second request: server address expected " + hostport0 + ", actual server address" + sock_addr), (Object)sock_addr, (Object)hostport0);
    }

    private void assertEqualConfiguration(Configuration config, RemoteCache rc) throws Exception {
        Assert.assertEquals((Object)((FailoverRequestBalancingStrategy)config.balancingStrategyFactory().get()).getClass().getName(), (Object)this.getRequestBalancingStrategyProperty(rc));
        String servers = this.getServerListProperty(rc);
        for (ServerConfiguration scfg : config.servers()) {
            boolean found = false;
            int port = 11222;
            Pattern patternIpv6 = Pattern.compile(IPV6_REGEX);
            Pattern patternIpv4 = Pattern.compile(IPV4_REGEX);
            for (String server : servers.split(";")) {
                String host;
                Matcher matcher6 = patternIpv6.matcher(server);
                Matcher matcher4 = patternIpv4.matcher(server);
                if (matcher6.matches()) {
                    host = matcher6.group(1);
                    port = Integer.parseInt(matcher6.group(2));
                } else if (matcher4.matches()) {
                    host = matcher4.group(1);
                    port = Integer.parseInt(matcher4.group(2));
                } else {
                    host = server;
                }
                if (!scfg.host().equals(host) || scfg.port() != port) continue;
                found = true;
            }
            if (found) continue;
            Assert.fail((String)("The remote cache manager was configured to have server with an address " + scfg.host() + ":" + scfg.port() + ", but it doesn't (" + servers + ")"));
        }
        Assert.assertEquals((Object)config.forceReturnValues(), (Object)Boolean.parseBoolean(this.getForceReturnValueProperty(rc)));
        Assert.assertEquals((Object)config.tcpNoDelay(), (Object)Boolean.parseBoolean(this.getTcpNoDelayProperty(rc)));
        Assert.assertEquals((Object)config.tcpKeepAlive(), (Object)Boolean.parseBoolean(this.getTcpKeepAliveProperty(rc)));
        Assert.assertEquals((long)config.maxRetries(), (long)Integer.parseInt(this.getMaxRetries(rc)));
        Assert.assertEquals((Object)config.asyncExecutorFactory().factoryClass().getName(), (Object)rc.getRemoteCacheManager().getConfiguration().asyncExecutorFactory().factoryClass().getName());
        if (config.marshaller() != null) {
            Assert.assertEquals((Object)config.marshaller().getClass().getName(), (Object)this.getMarshallerProperty(rc));
        } else {
            Assert.assertEquals((Object)config.marshallerClass().getName(), (Object)this.getMarshallerProperty(rc));
        }
        rc.stats();
        if (ITestUtils.isDistributedMode()) {
            Assert.assertEquals((Object)config.consistentHashImpl(3).getName(), (Object)this.getHashFunctionImplProperty(rc));
        }
        Assert.assertEquals((long)config.keySizeEstimate(), (long)this.getKeySizeEstimateProperty(rc));
        Assert.assertEquals((long)config.valueSizeEstimate(), (long)this.getValueSizeEstimateProperty(rc));
    }

    private String getRequestBalancingStrategyProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        FailoverRequestBalancingStrategy rbs = ttf.getBalancer(RemoteCacheManager.cacheNameBytes());
        return rbs.getClass().getName();
    }

    private String getServerListProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        Collection servers = ttf.getServers();
        StringBuilder serverList = new StringBuilder();
        int listSize = servers.size();
        int i = 0;
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            InetSocketAddress addr = this.resolve((InetSocketAddress)iter.next());
            if (addr.getAddress() instanceof Inet6Address) {
                serverList.append('[').append(addr.getHostName()).append(']');
            } else {
                serverList.append(addr.getHostName());
            }
            serverList.append(":");
            serverList.append(addr.getPort());
            if (i < listSize - 1) {
                serverList.append(";");
            }
            ++i;
        }
        return serverList.toString();
    }

    private String getForceReturnValueProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        boolean forceReturn = this.getForceReturnValueField(of);
        return Boolean.toString(forceReturn);
    }

    private String getTcpNoDelayProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        boolean tcpNoDelay = ttf.isTcpNoDelay();
        return Boolean.toString(tcpNoDelay);
    }

    private String getTcpKeepAliveProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        boolean tcpKeepAlive = ttf.isTcpKeepAlive();
        return Boolean.toString(tcpKeepAlive);
    }

    private String getMaxRetries(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        return Integer.toString(ttf.getMaxRetries());
    }

    private String getMarshallerProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        Marshaller m = this.getMarshallerField(rci);
        return m.getClass().getName();
    }

    private String getHashFunctionImplProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        OperationsFactory of = this.getOperationsFactoryField(rci);
        ChannelFactory ttf = this.getChannelFactoryField(of);
        ConsistentHash ch = ttf.getConsistentHash(rc.getName().getBytes());
        return ch.getClass().getName();
    }

    private int getKeySizeEstimateProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        return this.getEstimateKeySizeField(rci);
    }

    private int getValueSizeEstimateProperty(RemoteCache rc) throws Exception {
        RemoteCacheImpl rci = (RemoteCacheImpl)rc;
        return this.getEstimateValueSizeField(rci);
    }

    private OperationsFactory getOperationsFactoryField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("operationsFactory");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access operationsFactory field", e);
        }
        field.setAccessible(true);
        OperationsFactory fieldValue = null;
        try {
            fieldValue = (OperationsFactory)field.get(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access OperationsFactory field", e);
        }
        return fieldValue;
    }

    private int getEstimateKeySizeField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("estimateKeySize");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access estimateKeySize field", e);
        }
        field.setAccessible(true);
        int fieldValue = 0;
        try {
            fieldValue = field.getInt(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access estimateKeySize field", e);
        }
        return fieldValue;
    }

    private int getEstimateValueSizeField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("estimateValueSize");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access estimateValueSize field", e);
        }
        field.setAccessible(true);
        int fieldValue = 0;
        try {
            fieldValue = field.getInt(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access estimateValueSize field", e);
        }
        return fieldValue;
    }

    private Marshaller getMarshallerField(RemoteCacheImpl rci) throws Exception {
        Field field = null;
        try {
            field = RemoteCacheImpl.class.getDeclaredField("defaultMarshaller");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        field.setAccessible(true);
        Marshaller fieldValue = null;
        try {
            fieldValue = (Marshaller)field.get(rci);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access marshaller field", e);
        }
        return fieldValue;
    }

    private boolean getForceReturnValueField(OperationsFactory of) throws Exception {
        Field field = null;
        try {
            field = OperationsFactory.class.getDeclaredField("forceReturnValue");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access forceReturnValue field", e);
        }
        field.setAccessible(true);
        boolean fieldValue = false;
        try {
            fieldValue = field.getBoolean(of);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access forceReturnValue field", e);
        }
        return fieldValue;
    }

    private ChannelFactory getChannelFactoryField(OperationsFactory of) throws Exception {
        Field field = null;
        try {
            field = OperationsFactory.class.getDeclaredField("channelFactory");
        }
        catch (NoSuchFieldException e) {
            throw new Exception("Could not access transportFactory field", e);
        }
        field.setAccessible(true);
        ChannelFactory fieldValue = null;
        try {
            fieldValue = (ChannelFactory)field.get(of);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access transportFactory field", e);
        }
        return fieldValue;
    }

    private InetSocketAddress resolve(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return new InetSocketAddress(address.getHostString(), address.getPort());
        }
        return address;
    }

    private static class NoopChannelOperation
    extends CompletableFuture<Channel>
    implements ChannelOperation {
        private NoopChannelOperation() {
        }

        public void invoke(Channel channel) {
            this.complete(channel);
        }

        public void cancel(SocketAddress address, Throwable cause) {
            this.completeExceptionally(cause);
        }
    }
}

