/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferFactoryImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.server.test.category.HotRodSingleNode;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodSingleNode.class})
public class HotRodCustomMarshallerEventIT {
    private static final String MARSHALLER_JAR = "marshaller.jar";
    private final String TEST_CACHE_NAME = "default";
    static RemoteCacheManager remoteCacheManager;
    RemoteCache<Id, Id> remoteCache;
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;

    @Deployment(testable=false)
    @TargetsContainer(value="container1")
    public static Archive<?> deploy() {
        return ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)MARSHALLER_JAR)).addClasses(new Class[]{Id.class, IdMarshaller.class})).addAsServiceProvider(Marshaller.class, new Class[]{IdMarshaller.class});
    }

    @Before
    public void initialize() {
        if (remoteCacheManager == null) {
            Configuration config = this.createRemoteCacheManagerConfiguration();
            remoteCacheManager = new RemoteCacheManager(config, true);
        }
        this.remoteCache = remoteCacheManager.getCache("default");
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        for (RemoteInfinispanServer server : this.getServers()) {
            config.addServer().host(server.getHotrodEndpoint().getInetAddress().getHostName()).port(server.getHotrodEndpoint().getPort());
        }
        config.marshaller(IdMarshaller.class.getName());
        return config.build();
    }

    @AfterClass
    public static void after() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        new File(System.getProperty("server1.dist"), "/standalone/deploymentsmarshaller.jar").delete();
    }

    private List<RemoteInfinispanServer> getServers() {
        return Collections.unmodifiableList(Collections.singletonList(this.server1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventReceiveBasic() {
        IdEventListener eventListener = new IdEventListener();
        this.remoteCache.addClientListener((Object)eventListener);
        try {
            this.remoteCache.put((Object)new Id(1), (Object)new Id(11));
            ClientCacheEntryCreatedEvent created = (ClientCacheEntryCreatedEvent)eventListener.pollEvent();
            Assert.assertEquals((Object)new Id(1), (Object)created.getKey());
            this.remoteCache.put((Object)new Id(2), (Object)new Id(22));
            created = (ClientCacheEntryCreatedEvent)eventListener.pollEvent();
            Assert.assertEquals((Object)new Id(2), (Object)created.getKey());
            this.remoteCache.put((Object)new Id(1), (Object)new Id(111));
            ClientCacheEntryModifiedEvent modified = (ClientCacheEntryModifiedEvent)eventListener.pollEvent();
            Assert.assertEquals((Object)new Id(1), (Object)modified.getKey());
            this.remoteCache.remove((Object)new Id(1));
            ClientCacheEntryRemovedEvent removed = (ClientCacheEntryRemovedEvent)eventListener.pollEvent();
            Assert.assertEquals((Object)new Id(1), (Object)removed.getKey());
            this.remoteCache.remove((Object)new Id(2));
            removed = (ClientCacheEntryRemovedEvent)eventListener.pollEvent();
            Assert.assertEquals((Object)new Id(2), (Object)removed.getKey());
        }
        finally {
            this.remoteCache.removeClientListener((Object)eventListener);
        }
    }

    public static class IdMarshaller
    extends AbstractMarshaller {
        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) {
            Id obj = (Id)o;
            ByteBufferFactoryImpl factory = new ByteBufferFactoryImpl();
            return factory.newByteBuffer(new byte[]{obj.id}, 0, 1);
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
            return new Id(buf[0]);
        }

        public boolean isMarshallable(Object o) {
            return true;
        }

        public MediaType mediaType() {
            return MediaType.parse((String)"application/custom-id");
        }
    }

    public static class Id {
        final byte id;

        public Id(int id) {
            this.id = (byte)id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id1 = (Id)o;
            return this.id == id1.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    @ClientListener
    public static class IdEventListener {
        BlockingQueue<ClientEvent> events = new ArrayBlockingQueue<ClientEvent>(128);

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        @ClientCacheEntryRemoved
        public void handleCreatedEvent(ClientEvent e) {
            this.events.add(e);
        }

        public <E extends ClientEvent> E pollEvent() {
            try {
                ClientEvent event = this.events.poll(10L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)event);
                return (E)event;
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

