/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.GenderMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.UserMarshaller;
import org.infinispan.query.remote.client.ProtostreamSerializationContextInitializer;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="remote-iterator-local")})
public class HotRodCustomMarshallerIteratorIT {
    private static final String FILTER_MARSHALLER_DEPLOYMENT_JAR = "filter-marshaller.jar";
    private static final String TO_STRING_FILTER_CONVERTER_FACTORY_NAME = "to-string-filter-converter";
    private static final String PARAM_FILTER_CONVERTER_FACTORY_NAME = "param-filter-converter";
    private static final String CACHE_NAME = "default";
    private static RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;
    @InfinispanResource(value="remote-iterator-local")
    RemoteInfinispanServer server1;

    @BeforeClass
    public static void deploy() throws IOException {
        String protoFile = Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)HotRodCustomMarshallerIteratorIT.class.getClassLoader());
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)FILTER_MARSHALLER_DEPLOYMENT_JAR)).addClasses(new Class[]{HotRodClientException.class, UserMarshaller.class, GenderMarshaller.class, User.class, Address.class})).add((Asset)new StringAsset(protoFile), "/sample_bank_account/bank.proto")).add((Asset)new StringAsset("Dependencies: org.infinispan.protostream, org.infinispan.remote-query.client"), "META-INF/MANIFEST.MF")).addClass(ServerCtxInitializer.class)).addAsServiceProvider(ProtostreamSerializationContextInitializer.class, new Class[]{ServerCtxInitializer.class})).addClasses(new Class[]{CustomFilterFactory.class, CustomFilterFactory.CustomFilter.class, ParamCustomFilterFactory.class, ParamCustomFilterFactory.ParamCustomFilter.class})).addAsServiceProviderAndClasses(KeyValueFilterConverterFactory.class, new Class[]{ParamCustomFilterFactory.class, CustomFilterFactory.class});
        File deployment = new File(System.getProperty("server1.dist"), "/standalone/deployments/filter-marshaller.jar");
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment, true);
    }

    @Before
    public void setup() throws Exception {
        RemoteCacheManagerFactory remoteCacheManagerFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).marshaller((Marshaller)new CustomProtoStreamMarshaller());
        remoteCacheManager = remoteCacheManagerFactory.createManager(clientBuilder);
        this.remoteCache = remoteCacheManager.getCache(CACHE_NAME);
        this.waitForDeploymentCompletion();
    }

    private void waitForDeploymentCompletion() throws Exception {
        ModelControllerClient controllerClient = ModelControllerClient.Factory.create((String)this.server1.getHotrodEndpoint().getInetAddress().getHostName(), (int)9990);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)FILTER_MARSHALLER_DEPLOYMENT_JAR)});
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set("status");
        ITestUtils.eventually(() -> "success".equals(controllerClient.execute(op).get("outcome").asString()), 60000L);
    }

    @AfterClass
    public static void after() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
        new File(System.getProperty("server1.dist"), "/standalone/deployments/filter-marshaller.jar").delete();
    }

    @Test
    public void testIteration() {
        this.remoteCache.clear();
        for (int i = 0; i < 10; ++i) {
            User user = new User();
            user.setId(i);
            user.setName("name" + i);
            user.setSurname("surname" + i);
            this.remoteCache.put((Object)i, (Object)user);
        }
        Map<Object, Object> entryMap = this.iteratorToMap((CloseableIterator<Map.Entry<Object, Object>>)this.remoteCache.retrieveEntries(null, 10));
        Assert.assertEquals((long)10L, (long)entryMap.size());
        Assert.assertEquals((Object)((User)entryMap.get(2)).getName(), (Object)"name2");
        entryMap = this.iteratorToMap((CloseableIterator<Map.Entry<Object, Object>>)this.remoteCache.retrieveEntries(TO_STRING_FILTER_CONVERTER_FACTORY_NAME, 10));
        Assert.assertEquals((long)10L, (long)entryMap.size());
        Assert.assertTrue((boolean)((String)entryMap.get(2)).startsWith("User{"));
        entryMap = this.iteratorToMap((CloseableIterator<Map.Entry<Object, Object>>)this.remoteCache.retrieveEntries(PARAM_FILTER_CONVERTER_FACTORY_NAME, new Object[]{3}, null, 10));
        Assert.assertEquals((long)10L, (long)entryMap.size());
        Assert.assertTrue((boolean)entryMap.get(2).equals("Use"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> iteratorToMap(CloseableIterator<Map.Entry<Object, Object>> iterator) {
        HashMap<Object, Object> entryMap = new HashMap<Object, Object>();
        try {
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                entryMap.put(next.getKey(), next.getValue());
            }
        }
        finally {
            Assert.assertNotNull(iterator);
            iterator.close();
        }
        return entryMap;
    }

    @NamedFactory(name="param-filter-converter")
    public static class ParamCustomFilterFactory
    implements ParamKeyValueFilterConverterFactory<Integer, User, String> {
        public KeyValueFilterConverter<Integer, User, String> getFilterConverter(Object[] params) {
            return new ParamCustomFilter((Integer)params[0]);
        }

        public static class ParamCustomFilter
        extends AbstractKeyValueFilterConverter<Integer, User, String>
        implements Serializable {
            private final int maxLength;

            public ParamCustomFilter(int maxLength) {
                this.maxLength = maxLength;
            }

            public String filterAndConvert(Integer key, User value, Metadata metadata) {
                return value.toString().substring(0, this.maxLength);
            }
        }
    }

    @NamedFactory(name="to-string-filter-converter")
    public static class CustomFilterFactory
    implements KeyValueFilterConverterFactory<Integer, User, String> {
        public KeyValueFilterConverter<Integer, User, String> getFilterConverter() {
            return new CustomFilter();
        }

        public static class CustomFilter
        extends AbstractKeyValueFilterConverter<Integer, User, String>
        implements Serializable {
            public String filterAndConvert(Integer key, User value, Metadata metadata) {
                return value.toString();
            }
        }
    }

    public static class CustomProtoStreamMarshaller
    extends ProtoStreamMarshaller {
        public CustomProtoStreamMarshaller() throws IOException {
            SerializationContext serCtx = this.getSerializationContext();
            serCtx.registerProtoFiles(FileDescriptorSource.fromResources((ClassLoader)CustomProtoStreamMarshaller.class.getClassLoader(), (String[])new String[]{"/sample_bank_account/bank.proto"}));
            serCtx.registerMarshaller((BaseMarshaller)new UserMarshaller());
            serCtx.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        }
    }

    public static class ServerCtxInitializer
    implements ProtostreamSerializationContextInitializer {
        public void init(SerializationContext serializationContext) throws IOException {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources((ClassLoader)ServerCtxInitializer.class.getClassLoader(), (String[])new String[]{"/sample_bank_account/bank.proto"}));
            serializationContext.registerMarshaller((BaseMarshaller)new UserMarshaller());
            serializationContext.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        }
    }
}

