/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.Collection;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.server.test.category.HotRodClustered;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClustered.class})
public class HotRodMultimapIT {
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;
    private RemoteCacheManager remoteCacheManager;

    @Before
    public void initialize() {
        if (this.remoteCacheManager == null) {
            this.remoteCacheManager = new RemoteCacheManager(this.createRemoteCacheManagerConfiguration(), true);
        }
    }

    @Test
    public void testMultimap() {
        this.remoteCacheManager.administration().getOrCreateCache("cutes", "default");
        MultimapCacheManager multimapCacheManager = RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)this.remoteCacheManager);
        RemoteMultimapCache people = multimapCacheManager.get("cutes");
        people.put((Object)1, (Object)"Elaia");
        people.put((Object)1, (Object)"Oihana");
        Collection littles = (Collection)people.get((Object)1).join();
        Assert.assertEquals((long)2L, (long)littles.size());
        Assert.assertTrue((boolean)littles.contains("Elaia"));
        Assert.assertTrue((boolean)littles.contains("Oihana"));
    }

    private Configuration createRemoteCacheManagerConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort());
        return config.build();
    }
}

