/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.HashSet;
import java.util.stream.IntStream;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.server.test.category.HotRodClustered;
import org.infinispan.server.test.category.HotRodSingleNode;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodSingleNode.class, HotRodClustered.class})
public class HotRodRemoteCacheCompatIT {
    private static final String CACHE_NAME = "compatibilityCache";
    private static final int CACHE_SIZE = 1000;
    private static RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    @InfinispanResource(value="container1")
    RemoteInfinispanServer server1;

    @Before
    public void setup() {
        RemoteCacheManagerFactory remoteCacheManagerFactory = new RemoteCacheManagerFactory();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort());
        remoteCacheManager = remoteCacheManagerFactory.createManager(clientBuilder);
        this.remoteCache = remoteCacheManager.getCache(CACHE_NAME);
    }

    @AfterClass
    public static void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.getCache(CACHE_NAME).clear();
            remoteCacheManager.stop();
        }
    }

    @Test
    public void testIterationWithPrimitiveValues() {
        this.remoteCache.clear();
        IntStream.range(0, 1000).forEach(k -> this.remoteCache.put((Object)k, (Object)("value" + k)));
        HashSet keys = new HashSet();
        try (CloseableIterator iter = this.remoteCache.retrieveEntries(null, 10);){
            iter.forEachRemaining(e -> keys.add(e.getKey()));
        }
        Assert.assertEquals((long)1000L, (long)keys.size());
    }
}

