/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.server.test.client.hotrod.AbstractRemoteCacheIT;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Smoke.class})
@WithRunningServer(value={@RunningServer(name="filters-1-dist"), @RunningServer(name="filters-2-dist")})
public class HotRodRemoteCacheDistIT
extends AbstractRemoteCacheIT {
    @InfinispanResource(value="filters-1-dist")
    private RemoteInfinispanServer server1;
    @InfinispanResource(value="filters-2-dist")
    private RemoteInfinispanServer server2;
    private static final Set<File> deployments = new HashSet<File>();

    @BeforeClass
    public static void before() {
        Archive<?> pojoArchive = HotRodRemoteCacheDistIT.createPojoArchive();
        Archive<?> filterArchive = HotRodRemoteCacheDistIT.createFilterArchive();
        Archive<?> converterArchive = HotRodRemoteCacheDistIT.createConverterArchive();
        Archive<?> filterConverterArchive = HotRodRemoteCacheDistIT.createFilterConverterArchive();
        Archive<?> keyValueFilterConverterArchive = HotRodRemoteCacheDistIT.createKeyValueFilterConverterArchive();
        HotRodRemoteCacheDistIT.deployToServers(pojoArchive, "pojo.jar");
        HotRodRemoteCacheDistIT.deployToServers(filterArchive, "filter.jar");
        HotRodRemoteCacheDistIT.deployToServers(converterArchive, "converter.jar");
        HotRodRemoteCacheDistIT.deployToServers(filterConverterArchive, "filter-converter.jar");
        HotRodRemoteCacheDistIT.deployToServers(keyValueFilterConverterArchive, "key-value-filter-converter.jar");
    }

    private static void deployToServers(Archive<?> archive, String jarName) {
        File deployment1 = new File(System.getProperty("server1.dist"), "/standalone/deployments/" + jarName);
        File deployment2 = new File(System.getProperty("server2.dist"), "/standalone/deployments/" + jarName);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment1, true);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment2, true);
        deployments.add(deployment1);
        deployments.add(deployment2);
    }

    @AfterClass
    public static void after() {
        HotRodRemoteCacheDistIT.release();
        deployments.forEach(File::delete);
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        servers.add(this.server2);
        return Collections.unmodifiableList(servers);
    }
}

