/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.commons.test.categories.Smoke;
import org.infinispan.server.test.client.hotrod.AbstractRemoteCacheIT;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Smoke.class})
@WithRunningServer(value={@RunningServer(name="filters-local")})
public class HotRodRemoteCacheLocalIT
extends AbstractRemoteCacheIT {
    @InfinispanResource(value="filters-local")
    private RemoteInfinispanServer server1;
    private static final Set<File> deployments = new HashSet<File>();

    @BeforeClass
    public static void before() {
        Archive<?> pojoArchive = HotRodRemoteCacheLocalIT.createPojoArchive();
        Archive<?> filterArchive = HotRodRemoteCacheLocalIT.createFilterArchive();
        Archive<?> converterArchive = HotRodRemoteCacheLocalIT.createConverterArchive();
        Archive<?> filterConverterArchive = HotRodRemoteCacheLocalIT.createFilterConverterArchive();
        Archive<?> keyValueFilterConverterArchive = HotRodRemoteCacheLocalIT.createKeyValueFilterConverterArchive();
        HotRodRemoteCacheLocalIT.deployToServers(pojoArchive, "pojo.jar");
        HotRodRemoteCacheLocalIT.deployToServers(filterArchive, "filter.jar");
        HotRodRemoteCacheLocalIT.deployToServers(converterArchive, "converter.jar");
        HotRodRemoteCacheLocalIT.deployToServers(filterConverterArchive, "filter-converter.jar");
        HotRodRemoteCacheLocalIT.deployToServers(keyValueFilterConverterArchive, "key-value-filter-converter.jar");
    }

    private static void deployToServers(Archive<?> archive, String jarName) {
        File deployment = new File(System.getProperty("server1.dist"), "/standalone/deployments/" + jarName);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(deployment, true);
        deployments.add(deployment);
    }

    @AfterClass
    public static void after() {
        HotRodRemoteCacheLocalIT.release();
        deployments.forEach(File::delete);
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        return Collections.unmodifiableList(servers);
    }

    @Override
    protected String getCacheManagerName() {
        return "local";
    }
}

