/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.category.HotRodClusteredDomain;
import org.infinispan.server.test.client.hotrod.AbstractRemoteCacheManagerIT;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.ManagementClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={HotRodClusteredDomain.class})
public class HotRodRemoteCacheManagerDomainIT
extends AbstractRemoteCacheManagerIT {
    @InfinispanResource(value="master:server-one", jmxPort=4447)
    RemoteInfinispanServer server1;
    @InfinispanResource(value="master:server-two", jmxPort=4597)
    RemoteInfinispanServer server2;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        client.enableJmx();
        if (ITestUtils.isDistributedMode()) {
            testCache = "cmDistTestCache";
            client.addDistributedCacheConfiguration("distCacheConfiguration", "clustered");
            client.addDistributedCache(testCache, "clustered", "distCacheConfiguration");
        } else {
            testCache = "cmReplTestCache";
            client.addReplicatedCache(testCache, "clustered", "replicated");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ManagementClient client = ManagementClient.getInstance();
        if (ITestUtils.isDistributedMode()) {
            client.removeDistributedCache(testCache, "clustered");
            client.removeDistributedCacheConfiguration("distCacheConfiguration", "clustered");
        } else if (ITestUtils.isLocalMode()) {
            client.removeLocalCache(testCache, "default");
            client.removeDistributedCacheConfiguration("distCacheConfiguration", "default");
        } else {
            client.removeReplicatedCache(testCache, "clustered");
        }
        client.disableJmx();
    }

    @Override
    protected List<RemoteInfinispanServer> getServers() {
        ArrayList<RemoteInfinispanServer> servers = new ArrayList<RemoteInfinispanServer>();
        servers.add(this.server1);
        if (!ITestUtils.isLocalMode()) {
            servers.add(this.server2);
        }
        return Collections.unmodifiableList(servers);
    }
}

