/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.osgi;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.Note;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.AccountMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.AddressMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.GenderMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.LimitsMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.TransactionMarshaller;
import org.infinispan.protostream.sampledomain.marshallers.UserMarshaller;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.test.category.Osgi;
import org.infinispan.server.test.util.osgi.KarafTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.RawUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExam.class)
@Category(value={Osgi.class})
@ExamReactorStrategy(value={PerClass.class})
public class RemoteCacheOsgiIT
extends KarafTestSupport {
    private final String SERVER_HOST = "localhost";
    private final int HOTROD_PORT = 11222;
    private final String DEFAULT_CACHE = "localnotindexed";
    private final String INDEXED_CACHE = "localtestcache";
    private final String KARAF_VERSION = System.getProperty("version.karaf", "2.3.3");
    private final String RESOURCES_DIR = System.getProperty("resources.dir", System.getProperty("java.io.tmpdir"));
    private ConfigurationBuilder builder;
    private RemoteCacheManager manager;

    @Configuration
    public Option[] config() throws Exception {
        return new Option[]{KarafDistributionOption.karafDistributionConfiguration().unpackDirectory(new File("target/pax")).frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").version(this.KARAF_VERSION)).karafVersion(this.KARAF_VERSION), KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId("org.infinispan").artifactId("infinispan-remote").type("xml").classifier("features").versionAsInProject(), (String[])new String[]{"infinispan-remote"}), KarafDistributionOption.features((UrlReference)new RawUrlReference("file:///" + this.RESOURCES_DIR.replace("\\", "/") + "/test-features.xml"), (String[])new String[]{"query-sample-domain"}), KarafDistributionOption.editConfigurationFileExtend((String)"etc/jre.properties", (String)"jre-1.7", (Object)"sun.misc"), KarafDistributionOption.editConfigurationFileExtend((String)"etc/jre.properties", (String)"jre-1.6", (Object)"sun.misc"), KarafDistributionOption.keepRuntimeFolder(), RemoteCacheOsgiIT.localRepoForPAXUrl()};
    }

    @ProbeBuilder
    public static TestProbeBuilder exportTestPackages(TestProbeBuilder probeBuilder) {
        probeBuilder.setHeader("Export-Package", RemoteCacheOsgiIT.class.getPackage().getName());
        return probeBuilder;
    }

    @Before
    public void setUp() {
        this.builder = new ConfigurationBuilder();
        this.builder.addServer().host("localhost").port(11222);
    }

    @After
    public void tearDown() {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    @Test
    public void testCustomObjectPutGet() {
        Person p = new Person("Martin");
        this.manager = new RemoteCacheManager(this.builder.build());
        RemoteCache cache = this.manager.getCache("localnotindexed");
        cache.put((Object)"k1", (Object)p);
        Assert.assertEquals((Object)p, (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testAttributeQuery() throws Exception {
        this.builder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.manager = new RemoteCacheManager(this.builder.build());
        RemoteCache cache = this.manager.getCache("localtestcache");
        String bankSchemaFile = Util.read((InputStream)this.bundleContext.getBundle().getResource("/sample_bank_account/bank.proto").openStream());
        FileDescriptorSource fds = new FileDescriptorSource();
        fds.addProtoFile("sample_bank_account/bank.proto", bankSchemaFile);
        SerializationContext ctx = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.manager);
        ctx.registerProtoFiles(fds);
        ctx.registerMarshaller((BaseMarshaller)new UserMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new GenderMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new AddressMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new AccountMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new LimitsMarshaller());
        ctx.registerMarshaller((BaseMarshaller)new TransactionMarshaller());
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String testSchemaFile = protoSchemaBuilder.fileName("test.proto").addClass(Note.class).build(ctx);
        RemoteCache metadataCache = this.manager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)bankSchemaFile);
        metadataCache.put((Object)"test.proto", (Object)testSchemaFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        cache.put((Object)1, (Object)this.createUser1());
        cache.put((Object)2, (Object)this.createUser2());
        cache.put((Object)3, (Object)this.createNote());
        User userFromCache = (User)cache.get((Object)1);
        this.assertUser(userFromCache);
        Note noteFromCache = (Note)cache.get((Object)3);
        this.assertNote(noteFromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, list.get(0).getClass());
        this.assertUser((User)list.get(0));
        query = qf.from(Note.class).having("author.name").eq((Object)"name").build();
        list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Note.class, list.get(0).getClass());
        this.assertNote((Note)list.get(0));
    }

    private Note createNote() {
        Note note = new Note();
        note.setText("testing 123");
        User author = new User();
        author.setId(20);
        author.setName("name");
        author.setSurname("surname");
        note.setAuthor(author);
        return note;
    }

    private void assertNote(Note note) {
        Assert.assertNotNull((Object)note);
        Assert.assertEquals((Object)"testing 123", (Object)note.getText());
        Assert.assertNotNull((Object)note.getAuthor());
        Assert.assertEquals((long)20L, (long)note.getAuthor().getId());
        Assert.assertEquals((Object)"name", (Object)note.getAuthor().getName());
        Assert.assertEquals((Object)"surname", (Object)note.getAuthor().getSurname());
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(2);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertTrue((boolean)user.getAccountIds().contains(12));
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }

    static class Person
    implements Serializable {
        final String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

