/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.io.IOException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthClustered"), @RunningServer(name="hotrodAuthClustered-2")})
public class ContainerAdminIT {
    @InfinispanResource(value="hotrodAuthClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthClustered-2")
    RemoteInfinispanServer server2;
    private static RemoteCacheManager adminRCM = null;

    @Before
    public void prepareAdminRCM() {
        if (adminRCM == null) {
            SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
            config.forIspnServer(this.server1).withServerName("node0");
            config.forCredentials("admin", "strongPassword");
            adminRCM = new RemoteCacheManager(config.build(), true);
        }
    }

    @AfterClass
    public static void stopAdminRCM() {
        if (adminRCM != null) {
            adminRCM.stop();
            adminRCM = null;
        }
    }

    @Test
    public void testAdminOp() throws Exception {
        adminRCM.administration().getOrCreateCache("testAdminOp", "template");
    }

    @Test(expected=HotRodClientException.class)
    public void testAdminOpWithoutAdminPerm() throws IOException {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("writer", "somePassword");
        RemoteCacheManager writerRCM = new RemoteCacheManager(config.build(), true);
        try {
            writerRCM.administration().getOrCreateCache("testAdminOpWithoutAdminPerm", "template");
        }
        finally {
            writerRCM.stop();
        }
    }
}

