/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.security.PrivilegedActionException;
import javax.security.auth.login.LoginException;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodAuthzOperationTests;
import org.infinispan.server.test.client.hotrod.security.HotRodSaslAuthTestBase;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthClustered"), @RunningServer(name="hotrodAuthClustered-2")})
public class HotRodOperationsAuthzIT
extends HotRodSaslAuthTestBase {
    @InfinispanResource(value="hotrodAuthClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthClustered-2")
    RemoteInfinispanServer server2;

    @Override
    public String getTestedMech() {
        return "DIGEST-MD5";
    }

    @Override
    public RemoteInfinispanServer getRemoteServer() {
        return this.server1;
    }

    @Override
    public void initAsAdmin() {
        this.initialize("admin", "strongPassword");
    }

    @Override
    public void initAsReader() {
        this.initialize("reader", "password");
    }

    @Override
    public void initAsWriter() {
        this.initialize("writer", "somePassword");
    }

    @Override
    public void initAsSupervisor() {
        this.initialize("supervisor", "lessStrongPassword");
    }

    @Override
    @Test
    public void testAdmin() throws Exception {
        this.initAsAdmin();
        HotRodAuthzOperationTests.testGetRemoteCacheManager((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutClear((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutClearAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutContainsKey((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGet((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetBulk((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetVersioned((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetWithMetadata((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutAll((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutAllAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutIfAbsent((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutIfAbsentAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveContains((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveContainsAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveWithVersion((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveWithVersionAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithFlag((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithVersioned((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithVersionAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testSize((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testStats((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testAddGetClientListener((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveClientListener((RemoteCache<String, String>)this.remoteCache);
    }

    @Override
    @Test
    public void testSupervisor() throws Exception {
        this.initAsSupervisor();
        HotRodAuthzOperationTests.testGetRemoteCacheManager((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutClear((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutClearAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutContainsKey((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGet((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetBulk((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetVersioned((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutGetWithMetadata((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutAll((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutAllAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutIfAbsent((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutIfAbsentAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveContains((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveContainsAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveWithVersion((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveWithVersionAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithFlag((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithVersioned((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testReplaceWithVersionAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testSize((RemoteCache<String, String>)this.remoteCache);
    }

    @Override
    @Test
    public void testWriter() throws Exception {
        this.initAsWriter();
        HotRodAuthzOperationTests.testPut((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testPutAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemove((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testRemoveAsync((RemoteCache<String, String>)this.remoteCache);
    }

    @Override
    @Test
    public void testReader() throws Exception {
        this.initAsReader();
        HotRodAuthzOperationTests.testContainsKey((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testGetNonExistent((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testGetNonExistentAsync((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testGetVersioned((RemoteCache<String, String>)this.remoteCache);
        HotRodAuthzOperationTests.testGetWithMetadata((RemoteCache<String, String>)this.remoteCache);
    }

    @Test(expected=HotRodClientException.class)
    public void testSupervisorStats() throws PrivilegedActionException, LoginException {
        this.initAsSupervisor();
        HotRodAuthzOperationTests.testStats((RemoteCache<String, String>)this.remoteCache);
    }

    @Test(expected=HotRodClientException.class)
    public void testSupervisorAddListener() throws PrivilegedActionException, LoginException {
        this.initAsSupervisor();
        HotRodAuthzOperationTests.testAddGetClientListener((RemoteCache<String, String>)this.remoteCache);
    }

    @Test(expected=HotRodClientException.class)
    public void testWriterClear() throws PrivilegedActionException, LoginException {
        this.initAsWriter();
        HotRodAuthzOperationTests.testClear((RemoteCache<String, String>)this.remoteCache);
    }

    @Test(expected=HotRodClientException.class)
    public void testWriterReplaceWithReturnFlag() throws PrivilegedActionException, LoginException {
        this.initAsWriter();
        HotRodAuthzOperationTests.testReplaceWithFlag((RemoteCache<String, String>)this.remoteCache);
    }

    @Test(expected=HotRodClientException.class)
    public void testReaderClear() throws PrivilegedActionException, LoginException {
        this.initAsReader();
        HotRodAuthzOperationTests.testClear((RemoteCache<String, String>)this.remoteCache);
    }
}

