/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.io.File;
import javax.net.ssl.SSLContext;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.client.hotrod.security.HotRodAuthzOperationTests;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodSslNoAuth", config="testsuite/hotrod-ssl-no-auth.xml")})
public class HotRodSslEncryptionIT {
    protected static final String DEFAULT_TRUSTSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "ca.jks";
    protected static final String DEFAULT_TRUSTSTORE_PASSWORD = "secret";
    protected static RemoteCache<String, String> remoteCache = null;
    protected static RemoteCacheManager remoteCacheManager = null;
    @InfinispanResource(value="hotrodSslNoAuth")
    RemoteInfinispanServer ispnServer;

    @After
    public void release() {
        if (remoteCacheManager != null) {
            remoteCacheManager.stop();
        }
    }

    @Test
    public void testViaDirectConfig() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        String hostname = this.ispnServer.getHotrodEndpoint().getInetAddress().getHostName();
        builder.addServer().host(hostname).port(this.ispnServer.getHotrodEndpoint().getPort());
        builder.security().ssl().enable().trustStoreFileName(DEFAULT_TRUSTSTORE_PATH).trustStorePassword(DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
        remoteCacheManager = new RemoteCacheManager(builder.build());
        remoteCache = remoteCacheManager.getCache("___defaultcache");
        HotRodAuthzOperationTests.testPutGet(remoteCache);
        HotRodAuthzOperationTests.testSize(remoteCache);
    }

    @Test
    public void testViaSslContextSetup() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        String hostname = this.ispnServer.getHotrodEndpoint().getInetAddress().getHostName();
        builder.addServer().host(hostname).port(this.ispnServer.getHotrodEndpoint().getPort());
        SSLContext cont = SslContextFactory.getContext(null, null, (String)DEFAULT_TRUSTSTORE_PATH, (char[])DEFAULT_TRUSTSTORE_PASSWORD.toCharArray());
        builder.security().ssl().sslContext(cont).enable();
        remoteCacheManager = new RemoteCacheManager(builder.build());
        remoteCache = remoteCacheManager.getCache("___defaultcache");
        HotRodAuthzOperationTests.testPutGet(remoteCache);
        HotRodAuthzOperationTests.testSize(remoteCache);
    }
}

