/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.hotrod.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.server.test.category.Security;
import org.infinispan.server.test.util.security.SecurityConfigurationHelper;
import org.infinispan.test.TestingUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={Security.class})
@WithRunningServer(value={@RunningServer(name="hotrodAuthClustered"), @RunningServer(name="hotrodAuthClustered-2")})
public class SecuredScriptExecIT {
    @InfinispanResource(value="hotrodAuthClustered")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="hotrodAuthClustered-2")
    RemoteInfinispanServer server2;
    private static RemoteCacheManager adminRCM = null;

    @Before
    public void prepareAdminRCM() {
        if (adminRCM == null) {
            SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
            config.forIspnServer(this.server1).withServerName("node0");
            config.forCredentials("admin", "strongPassword");
            adminRCM = new RemoteCacheManager(config.build(), true);
        }
    }

    @AfterClass
    public static void stopAdminRCM() {
        if (adminRCM != null) {
            adminRCM.stop();
            adminRCM = null;
        }
    }

    private void uploadScript(String ... scripts) throws IOException {
        RemoteCache scriptCache = adminRCM.getCache("___script_cache");
        for (String script : scripts) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
                scriptCache.put((Object)script, (Object)TestingUtil.loadFileAsString((InputStream)in));
            }
        }
    }

    @Test
    public void testExecuteScript() throws Exception {
        this.uploadScript("test.js");
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("executor", "executorPassword");
        RemoteCacheManager execRCM = new RemoteCacheManager(config.build(), true);
        RemoteCache cache = execRCM.getCache("customTaskCache");
        Assert.assertEquals((long)cache.size(), (long)0L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "test_key");
        params.put("value", "test_value");
        int result = (Integer)cache.execute("test.js", params);
        Assert.assertEquals((long)result, (long)1L);
        Assert.assertEquals((long)cache.size(), (long)1L);
        Assert.assertEquals((Object)cache.get((Object)"test_key"), (Object)"test_value");
        execRCM.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=HotRodClientException.class)
    public void testExecuteScriptWithoutExecPerm() throws IOException {
        this.uploadScript("test.js");
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("writer", "somePassword");
        RemoteCacheManager writerRCM = new RemoteCacheManager(config.build(), true);
        RemoteCache cache = writerRCM.getCache("customTaskCache");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "test_key");
        params.put("value", "test_value");
        try {
            cache.execute("test.js", params);
        }
        finally {
            writerRCM.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=HotRodClientException.class)
    public void testUploadScriptWithoutAdminPerm() {
        SecurityConfigurationHelper config = new SecurityConfigurationHelper("DIGEST-MD5");
        config.forIspnServer(this.server1).withServerName("node0");
        config.forCredentials("executor", "executorPassword");
        RemoteCacheManager execRCM = new RemoteCacheManager(config.build(), true);
        RemoteCache scriptCache = execRCM.getCache("___script_cache");
        try {
            scriptCache.put((Object)"shouldNotPass", (Object)"1+1");
        }
        finally {
            execRCM.stop();
        }
    }
}

