/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.net.URI;
import java.util.List;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRESTAsyncIT {
    RESTHelper rest;

    protected abstract int getRestPort1();

    protected abstract int getRestPort2();

    protected abstract List<RemoteInfinispanServer> getServers();

    @Before
    public void setUp() throws Exception {
        this.rest = new RESTHelper();
        if (ITestUtils.isReplicatedMode()) {
            this.rest.addServer(this.getServers().get(0).getRESTEndpoint().getInetAddress().getHostName(), this.getRestPort1(), this.getServers().get(0).getRESTEndpoint().getContextPath());
            this.rest.addServer(this.getServers().get(1).getRESTEndpoint().getInetAddress().getHostName(), this.getRestPort2(), this.getServers().get(1).getRESTEndpoint().getContextPath());
        } else {
            this.rest.addServer(this.getServers().get(0).getRESTEndpoint().getInetAddress().getHostName(), this.getServers().get(0).getRESTEndpoint().getContextPath());
            this.rest.addServer(this.getServers().get(1).getRESTEndpoint().getInetAddress().getHostName(), this.getServers().get(1).getRESTEndpoint().getContextPath());
        }
        this.rest.delete(this.rest.fullPathKey("a"));
        this.rest.head(this.rest.fullPathKey("a"), 404);
    }

    @After
    public void tearDown() throws Exception {
        this.rest.delete(this.rest.fullPathKey(null));
        this.rest.clearServers();
    }

    @Test
    public void testPutOperation() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        int NUM_OPERATIONS = 1000;
        String initialXML = "<hey>ho</hey>";
        StringBuilder initial = new StringBuilder(initialXML);
        for (int i = 0; i < 200; ++i) {
            initial.append("expanding");
        }
        initialXML = initial.toString();
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < NUM_OPERATIONS; ++i) {
            this.rest.put(fullPathKey, initialXML, "application/octet-stream", 200, "performAsync", "false");
        }
        long putSyncTime = System.currentTimeMillis() - t1;
        this.rest.delete(fullPathKey);
        t1 = System.currentTimeMillis();
        for (int i = 0; i < NUM_OPERATIONS; ++i) {
            this.rest.put(fullPathKey, initialXML, "application/octet-stream", 200, "performAsync", "true");
        }
        long putAsyncTime = System.currentTimeMillis() - t1;
        Assert.assertTrue((String)("PUT : async- " + putAsyncTime + ", sync- " + putSyncTime), (putAsyncTime < putSyncTime ? 1 : 0) != 0);
        this.rest.get(fullPathKey, initialXML, 200, true, "performAsync", "true");
    }

    @Test
    public void testDeleteOperation() throws Exception {
        int i;
        int NUM_OPERATIONS = 15;
        int SIZE = 900;
        byte[] bytes = new byte[SIZE];
        for (i = 0; i < SIZE; ++i) {
            bytes[i] = (byte)(i % 10);
        }
        for (i = 0; i < NUM_OPERATIONS; ++i) {
            this.rest.put(this.rest.fullPathKey(String.valueOf(i)), bytes, "application/octet-stream", 200, "performAsync", "false");
        }
        for (i = 0; i < NUM_OPERATIONS; ++i) {
            this.rest.delete(this.rest.fullPathKey(String.valueOf(i)), 200, "performAsync", "true");
        }
        i = 0;
        while (i < NUM_OPERATIONS) {
            final int iter = i++;
            ITestUtils.eventually(new ITestUtils.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return AbstractRESTAsyncIT.this.rest.getWithoutAssert(AbstractRESTAsyncIT.this.rest.fullPathKey(String.valueOf(iter)), null, 404, true, "performAsync", "true");
                }
            }, 5000L, 10);
        }
        this.rest.put(this.rest.fullPathKey("a"), "a", "application/octet-stream");
        this.rest.put(this.rest.fullPathKey("b"), "b", "application/octet-stream");
        this.rest.delete(this.rest.fullPathKey(null), 200, "performAsync", "true");
        ITestUtils.eventually(new ITestUtils.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return AbstractRESTAsyncIT.this.rest.getWithoutAssert(AbstractRESTAsyncIT.this.rest.fullPathKey("a"), null, 404, true, new Object[0]) && AbstractRESTAsyncIT.this.rest.getWithoutAssert(AbstractRESTAsyncIT.this.rest.fullPathKey("b"), null, 404, true, new Object[0]);
            }
        }, 5000L, 10);
    }
}

