/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRESTClientIT {
    protected RESTHelper rest;
    protected static final String REST_NAMED_CACHE = "restNamedCache";
    protected static final String REST_NAMED_CACHE_TEXT = "restNamedCacheText";

    protected abstract void addRestServer();

    protected String getDefaultCache() {
        return "default";
    }

    @Before
    public void setUp() throws Exception {
        this.rest = new RESTHelper(this.getDefaultCache());
        this.addRestServer();
        this.cleanUpEntries();
        this.rest.head(this.rest.fullPathKey("a"), 404);
        this.rest.head(this.rest.fullPathKey("b"), 404);
        this.rest.head(this.rest.fullPathKey("c"), 404);
        this.rest.head(this.rest.fullPathKey(REST_NAMED_CACHE, "a"), 404);
        this.rest.head(this.rest.fullPathKey(REST_NAMED_CACHE_TEXT, "a"), 404);
    }

    private void cleanUpEntries() throws Exception {
        this.rest.delete(this.rest.fullPathKey("a"));
        this.rest.delete(this.rest.fullPathKey("b"));
        this.rest.delete(this.rest.fullPathKey("c"));
        this.rest.delete(this.rest.fullPathKey(REST_NAMED_CACHE, "a"));
        this.rest.delete(this.rest.fullPathKey(REST_NAMED_CACHE_TEXT, "a"));
    }

    @After
    public void tearDown() throws Exception {
        this.cleanUpEntries();
        this.rest.clearServers();
    }

    @Test
    public void testBasicOperation() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        String initialXML = "<hey>ho</hey>";
        HttpResponse insert = this.rest.put(fullPathKey, initialXML, "application/octet-stream");
        Assert.assertEquals((long)0L, (long)insert.getEntity().getContentLength());
        HttpResponse get = this.rest.get(fullPathKey, initialXML);
        Assert.assertEquals((Object)"application/octet-stream", (Object)get.getHeaders("Content-Type")[0].getValue());
        this.rest.delete(fullPathKey);
        this.rest.get(fullPathKey, 404);
        this.rest.put(fullPathKey, initialXML, "application/octet-stream");
        this.rest.get(fullPathKey, initialXML);
        this.rest.delete(this.rest.fullPathKey(null));
        this.rest.get(fullPathKey, 404);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new TestSerializable("CONTENT"));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        this.rest.put(fullPathKey, byteData, "application/octet-stream");
        HttpResponse resp = this.rest.getWithoutClose(fullPathKey);
        ObjectInputStream oin = new ObjectInputStream(resp.getEntity().getContent());
        TestSerializable ts = (TestSerializable)oin.readObject();
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((Object)"CONTENT", (Object)ts.getContent());
    }

    @Test
    public void testEmptyGet() throws Exception {
        this.rest.get(this.rest.fullPathKey("nodata"), 404);
    }

    @Test
    public void testGetWithoutMediaTypeConfig() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey, "data");
        Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"application/octet-stream", (Object)resp.getHeaders("Content-Type")[0].getValue());
    }

    @Test
    public void testGetWithMediaTypeConfig() throws Exception {
        URI fullPathKey = this.rest.fullPathKey(REST_NAMED_CACHE_TEXT, "a");
        this.rest.post(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey, "data");
        Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"text/plain", (Object)resp.getHeaders("Content-Type")[0].getValue());
    }

    @Test
    public void testGetNamedCache() throws Exception {
        URI fullPathKey = this.rest.fullPathKey(REST_NAMED_CACHE_TEXT, "a");
        this.rest.post(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey, "data");
        Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"text/plain", (Object)resp.getHeaders("Content-Type")[0].getValue());
    }

    @Test
    public void testHead() throws Exception {
        URI fullPathKey = this.rest.fullPathKey(REST_NAMED_CACHE_TEXT, "a");
        this.rest.post(fullPathKey, "data", "text/plain");
        HttpResponse resp = null;
        try {
            resp = this.rest.headWithoutClose(fullPathKey);
            Assert.assertNotNull((Object)resp.getHeaders("ETag")[0].getValue());
            Assert.assertNotNull((Object)resp.getHeaders("Last-Modified")[0].getValue());
            Assert.assertEquals((Object)"text/plain", (Object)resp.getHeaders("Content-Type")[0].getValue());
            Assert.assertNull((Object)resp.getEntity());
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    @Test
    public void testPostDuplicate() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain");
        this.rest.post(fullPathKey, "data", "text/plain", 409);
        this.rest.put(fullPathKey, "data", "text/plain");
    }

    @Test
    public void testPutDataWithTimeToLive() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain", 200, "Content-Type", "text/plain", "timeToLiveSeconds", "2");
        this.rest.get(fullPathKey, "data");
        ITestUtils.sleepForSecs(2.1);
        this.rest.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataWithMaxIdleTime() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain", 200, "Content-Type", "text/plain", "maxIdleTimeSeconds", "2");
        this.rest.get(fullPathKey, "data");
        for (int i = 1; i < 3; ++i) {
            ITestUtils.sleepForSecs(1.0);
            this.rest.head(fullPathKey);
        }
        ITestUtils.sleepForSecs(2.1);
        this.rest.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataTTLMaxIdleCombo1() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain", 200, "Content-Type", "text/plain", "timeToLiveSeconds", "10", "maxIdleTimeSeconds", "2");
        this.rest.get(fullPathKey, "data");
        for (int i = 1; i < 3; ++i) {
            ITestUtils.sleepForSecs(1.0);
            this.rest.head(fullPathKey);
        }
        ITestUtils.sleepForSecs(2.1);
        this.rest.head(fullPathKey, 404);
    }

    @Test
    public void testPutDataTTLMaxIdleCombo2() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain", 200, "Content-Type", "text/plain", "timeToLiveSeconds", "2", "maxIdleTimeSeconds", "10");
        this.rest.get(fullPathKey, "data");
        ITestUtils.sleepForSecs(2.1);
        this.rest.head(fullPathKey, 404);
    }

    @Test
    public void testRemoveEntry() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.post(fullPathKey, "data", "text/plain");
        this.rest.head(fullPathKey);
        this.rest.delete(fullPathKey);
        this.rest.head(fullPathKey, 404);
    }

    @Test
    public void testWipeCacheBucket() throws Exception {
        this.rest.post(this.rest.fullPathKey("a"), "data", "text/plain");
        this.rest.post(this.rest.fullPathKey("b"), "data", "text/plain");
        this.rest.head(this.rest.fullPathKey("a"));
        this.rest.head(this.rest.fullPathKey("b"));
        this.rest.delete(this.rest.fullPathKey(null));
        this.rest.head(this.rest.fullPathKey("a"), 404);
        this.rest.head(this.rest.fullPathKey("b"), 404);
    }

    @Test
    public void testPutUnknownClass() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("x");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new TestSerializable("CONTENT"));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        this.rest.put(fullPathKey, byteData, "application/octet-stream");
        HttpResponse resp = this.rest.get(fullPathKey, null, 200, false, "Accept", "application/octet-stream");
        ObjectInputStream oin = new ObjectInputStream(resp.getEntity().getContent());
        TestSerializable ts = (TestSerializable)oin.readObject();
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((Object)"CONTENT", (Object)ts.getContent());
    }

    @Test
    public void testPutKnownClass() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("y");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        Integer i1 = 42;
        oo.writeObject(i1);
        oo.flush();
        byte[] byteData = bout.toByteArray();
        this.rest.put(fullPathKey, byteData, "application/octet-stream");
        HttpResponse resp = this.rest.get(fullPathKey, null, 200, false, "Accept", "application/octet-stream");
        ObjectInputStream oin = new ObjectInputStream(resp.getEntity().getContent());
        Integer i2 = (Integer)oin.readObject();
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((Object)i1, (Object)i2);
    }

    @Test
    public void testETagChanges() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.put(fullPathKey, "data1", "text/plain");
        String eTagFirst = this.rest.get(fullPathKey).getHeaders("ETag")[0].getValue();
        Assert.assertEquals((Object)eTagFirst, (Object)this.rest.get(fullPathKey).getHeaders("ETag")[0].getValue());
        this.rest.put(fullPathKey, "data2", "text/plain");
        Assert.assertFalse((boolean)eTagFirst.equals(this.rest.get(fullPathKey).getHeaders("ETag")[0].getValue()));
    }

    @Test
    public void testXJavaSerializedObjectPutAndDelete() throws Exception {
        URI fullPathKey1 = this.rest.fullPathKey("j");
        this.rest.put(fullPathKey1, "data1", "text/plain");
        this.rest.head(fullPathKey1, 200);
        this.rest.delete(fullPathKey1);
        this.rest.head(fullPathKey1, 404);
        URI fullPathKey2 = this.rest.fullPathKey("k");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        Integer i1 = 42;
        oo.writeObject(i1);
        oo.flush();
        byte[] byteData = bout.toByteArray();
        this.rest.put(fullPathKey2, byteData, "application/octet-stream");
        this.rest.head(fullPathKey2, 200);
        this.rest.delete(fullPathKey2);
        this.rest.head(fullPathKey2, 404);
    }

    @Test
    public void testIfModifiedSince() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.put(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey);
        String dateLast = resp.getHeaders("Last-Modified")[0].getValue();
        String dateMinus = RESTHelper.addDay(dateLast, -1);
        String datePlus = RESTHelper.addDay(dateLast, 1);
        this.rest.get(fullPathKey, null, 304, true, "If-Modified-Since", dateLast);
    }

    @Test
    public void testIfUnmodifiedSince() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.put(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey);
        String dateLast = resp.getHeaders("Last-Modified")[0].getValue();
        String dateMinus = RESTHelper.addDay(dateLast, -1);
        String datePlus = RESTHelper.addDay(dateLast, 1);
        this.rest.get(fullPathKey, "data", 200, true, "If-Unmodified-Since", dateLast);
        this.rest.get(fullPathKey, "data", 200, true, "If-Unmodified-Since", datePlus);
        this.rest.get(fullPathKey, null, 412, true, "If-Unmodified-Since", dateMinus);
    }

    @Test
    public void testIfNoneMatch() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.put(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey);
        String eTag = resp.getHeaders("ETag")[0].getValue();
        this.rest.get(fullPathKey, null, 304, true, "If-None-Match", eTag);
        this.rest.get(fullPathKey, "data", 200, true, "If-None-Match", eTag + "garbage");
    }

    @Test
    public void testIfMatch() throws Exception {
        URI fullPathKey = this.rest.fullPathKey("a");
        this.rest.put(fullPathKey, "data", "text/plain");
        HttpResponse resp = this.rest.get(fullPathKey);
        String eTag = resp.getHeaders("ETag")[0].getValue();
        this.rest.get(fullPathKey, "data", 200, true, "If-Match", eTag);
        this.rest.get(fullPathKey, null, 412, true, "If-Match", eTag + "garbage");
        this.rest.head(fullPathKey, 200, new String[][]{{"If-Match", eTag}});
        this.rest.head(fullPathKey, 412, new String[][]{{"If-Match", eTag + "garbage"}});
    }

    @Test
    public void testNonExistentCache() throws Exception {
        this.rest.get(this.rest.fullPathKey("nonexistentcache", "nodata"), 404);
        this.rest.put(this.rest.fullPathKey("nonexistentcache", "nodata"), "data", "text/plain", 404);
        this.rest.delete(this.rest.fullPathKey("nonexistentcache", "nodata"), 404, new Object[0]);
    }

    @Test
    public void testByteArrayStorage() throws Exception {
        String KEY_Z = "z";
        byte[] data = "data".getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] serializedData = bout.toByteArray();
        this.rest.put(this.rest.fullPathKey(0, "z"), serializedData, "application/octet-stream");
        HttpResponse resp = this.rest.get(this.rest.fullPathKey(0, "z"), null, 200, false, "Accept", "application/octet-stream");
        ObjectInputStream oin = new ObjectInputStream(resp.getEntity().getContent());
        byte[] dataBack = (byte[])oin.readObject();
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    @Test
    public void testStoreBigObject() throws Exception {
        byte data;
        int SIZE = 3000000;
        byte[] bytes = new byte[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            bytes[i] = (byte)(i % 10);
        }
        this.rest.put(this.rest.fullPathKey("object"), bytes, "application/octet-stream");
        HttpResponse resp = this.rest.getWithoutClose(this.rest.fullPathKey("object"));
        InputStream responseStream = resp.getEntity().getContent();
        byte[] response = new byte[SIZE];
        int j = 0;
        while ((data = (byte)responseStream.read()) != -1) {
            response[j] = data;
            ++j;
        }
        boolean correct = true;
        for (int i = 0; i < SIZE; ++i) {
            if (bytes[i] == response[i]) continue;
            correct = false;
        }
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertTrue((boolean)correct);
    }

    @Test
    public void testKeyIncludingSlashURLEncoded() throws Exception {
        String encodedSlashKey = URLEncoder.encode("x/y", "UTF-8");
        this.rest.post(this.rest.fullPathKey(encodedSlashKey), "data", "text/plain");
        HttpResponse get = this.rest.get(this.rest.fullPathKey(encodedSlashKey), "data");
        Assert.assertNotNull((Object)get.getHeaders("ETag")[0].getValue());
        Assert.assertNotNull((Object)get.getHeaders("Last-Modified")[0].getValue());
        Assert.assertEquals((Object)"application/octet-stream", (Object)get.getHeaders("Content-Type")[0].getValue());
    }

    public static class TestSerializable
    implements Serializable {
        private String content;

        public TestSerializable(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }
}

