/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.client.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet6Address;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.arquillian.core.RESTEndpoint;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.junit.Assert;

public class RESTHelper {
    public static final String KEY_A = "a";
    public static final String KEY_B = "b";
    public static final String KEY_C = "c";
    public static final String DEFAULT_CACHE = "default";
    private final String cache;
    private int port = 8080;
    private String protocol = "http";
    private List<Server> servers = new ArrayList<Server>();
    private CredentialsProvider credsProvider = new BasicCredentialsProvider();
    public CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider(this.credsProvider).build();

    public RESTHelper(String cache) {
        this.cache = cache;
    }

    public RESTHelper() {
        this.cache = DEFAULT_CACHE;
    }

    public RESTHelper withPort(int port) {
        this.port = port;
        return this;
    }

    public RESTHelper withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public RESTHelper withSslContext(SSLContext sslContext) {
        this.client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        return this;
    }

    public RESTHelper withServer(RemoteInfinispanServer server) {
        this.servers.add(new Server(server));
        return this;
    }

    public RESTHelper withServers(RemoteInfinispanServer ... servers) {
        for (RemoteInfinispanServer server : servers) {
            this.servers.add(new Server(server));
        }
        return this;
    }

    public void addServer(String hostname, String restServerPath) {
        this.servers.add(new Server(hostname, restServerPath));
    }

    public void clearServers() {
        this.servers.clear();
    }

    public void addServer(String hostname, int port, String restServerPath) {
        this.port = port;
        this.servers.add(new Server(hostname, restServerPath));
    }

    public static String addDay(String aDate, int days) {
        ZonedDateTime date = ZonedDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(aDate));
        date = date.plusDays(days);
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(date);
    }

    public HttpResponse head(URI uri) throws Exception {
        return this.head(uri, 200);
    }

    public HttpResponse headWithoutClose(URI uri) throws Exception {
        return this.head(uri, 200);
    }

    public HttpResponse head(URI uri, int expectedCode) throws Exception {
        return this.head(uri, expectedCode, new String[0][0]);
    }

    public HttpResponse headWithoutClose(URI uri, int expectedCode) throws Exception {
        return this.head(uri, expectedCode, new String[0][0]);
    }

    public HttpResponse headWithout(URI uri, int expectedCode, String[][] headers) throws Exception {
        HttpHead head = new HttpHead(uri);
        for (String[] eachHeader : headers) {
            head.setHeader(eachHeader[0], eachHeader[1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)head);
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse head(URI uri, int expectedCode, String[][] headers) throws Exception {
        HttpHead head = new HttpHead(uri);
        CloseableHttpResponse resp = null;
        try {
            for (String[] eachHeader : headers) {
                head.setHeader(eachHeader[0], eachHeader[1]);
            }
            resp = this.client.execute((HttpUriRequest)head);
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        Assert.assertEquals((long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public HttpResponse get(URI uri) throws Exception {
        return this.get(uri, 200);
    }

    public HttpResponse getWithoutClose(URI uri) throws Exception {
        return this.getWithoutClose(uri, 200);
    }

    public HttpResponse get(URI uri, String expectedResponseBody) throws Exception {
        return this.get(uri, expectedResponseBody, 200, true, new Object[0]);
    }

    public HttpResponse getWithoutClose(URI uri, String expectedResponseBody) throws Exception {
        return this.get(uri, expectedResponseBody, 200, false, new Object[0]);
    }

    public HttpResponse get(URI uri, int expectedCode) throws Exception {
        return this.get(uri, null, expectedCode, true, new Object[0]);
    }

    public HttpResponse getWithoutClose(URI uri, int expectedCode) throws Exception {
        return this.get(uri, null, expectedCode, false, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse get(URI uri, String expectedResponseBody, int expectedCode, boolean closeConnection, Object ... headers) throws Exception {
        HttpGet get = new HttpGet(uri);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            get.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)get);
        try {
            Assert.assertEquals((String)uri.toString(), (long)expectedCode, (long)resp.getStatusLine().getStatusCode());
            if (expectedResponseBody != null) {
                Assert.assertEquals((Object)expectedResponseBody, (Object)EntityUtils.toString((HttpEntity)resp.getEntity()));
            }
        }
        finally {
            if (closeConnection) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getWithoutAssert(URI uri, String expectedResponseBody, int expectedCode, boolean closeConnection, Object ... headers) throws Exception {
        HttpGet get = new HttpGet(uri);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            get.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)get);
        try {
            if (expectedCode != resp.getStatusLine().getStatusCode()) {
                boolean bl = false;
                return bl;
            }
            if (expectedResponseBody != null && !expectedResponseBody.equals(EntityUtils.toString((HttpEntity)resp.getEntity()))) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (closeConnection) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
        }
        return true;
    }

    public HttpResponse put(URI uri, Object data, String contentType) throws Exception {
        return this.put(uri, data, contentType, 200);
    }

    public HttpResponse put(URI uri, Object data, String contentType, int expectedCode) throws Exception {
        return this.put(uri, data, contentType, expectedCode, new Object[0]);
    }

    public HttpResponse put(URI uri, Object data, String contentType, int expectedCode, Object ... headers) throws Exception {
        HttpPut put = new HttpPut(uri);
        if (data instanceof String) {
            put.setEntity((HttpEntity)new StringEntity((String)data, "UTF-8"));
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            ByteArrayInputStream bs = new ByteArrayInputStream(byteData);
            put.setEntity((HttpEntity)new InputStreamEntity((InputStream)bs, (long)byteData.length));
        } else {
            throw new IllegalArgumentException("Unknown data type for PUT method");
        }
        put.setHeader("Content-Type", contentType);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            put.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)put);
        String responseBody = IOUtils.toString((Reader)new InputStreamReader(resp.getEntity().getContent()));
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((String)(responseBody + " [URI=" + uri + "]"), (long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public void setCredentials(String username, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        this.credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
    }

    public void clearCredentials() {
        this.credsProvider.clear();
    }

    public void setSni(SSLContext sslContext, final Optional<String> sniHostName) {
        this.client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE){

            protected void prepareSocket(SSLSocket socket) throws IOException {
                if (sniHostName.isPresent()) {
                    SSLParameters sslParameters = socket.getSSLParameters();
                    sslParameters.setServerNames(Arrays.asList(new SNIHostName((String)sniHostName.get())));
                    socket.setSSLParameters(sslParameters);
                }
            }
        }).build();
    }

    public HttpResponse post(URI uri, Object data, String contentType) throws Exception {
        return this.post(uri, data, contentType, 200);
    }

    public HttpResponse post(URI uri, Object data, String contentType, int expectedCode) throws Exception {
        return this.post(uri, data, contentType, expectedCode, new Object[0]);
    }

    public HttpResponse post(URI uri, Object data, String contentType, int expectedCode, Object ... headers) throws Exception {
        HttpPost post = new HttpPost(uri);
        if (data instanceof String) {
            post.setEntity((HttpEntity)new StringEntity((String)data, "UTF-8"));
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            ByteArrayInputStream bs = new ByteArrayInputStream(byteData);
            post.setEntity((HttpEntity)new InputStreamEntity((InputStream)bs, (long)byteData.length));
        } else {
            throw new IllegalArgumentException("Unknown data type for POST method");
        }
        post.setHeader("Content-Type", contentType);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            post.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)post);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        int statusCode = resp.getStatusLine().getStatusCode();
        Assert.assertEquals((String)("URI=" + uri), (long)expectedCode, (long)statusCode);
        return resp;
    }

    public HttpResponse delete(URI uri) throws Exception {
        HttpDelete delete = new HttpDelete(uri);
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)delete);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        return resp;
    }

    public HttpResponse delete(URI uri, int expectedCode, Object ... headers) throws Exception {
        HttpDelete delete = new HttpDelete(uri);
        if (headers.length % 2 != 0) {
            throw new IllegalArgumentException("bad headers argument");
        }
        for (int i = 0; i < headers.length; i += 2) {
            delete.setHeader((String)headers[i], (String)headers[i + 1]);
        }
        CloseableHttpResponse resp = this.client.execute((HttpUriRequest)delete);
        EntityUtils.consume((HttpEntity)resp.getEntity());
        Assert.assertEquals((String)("URI=" + uri), (long)expectedCode, (long)resp.getStatusLine().getStatusCode());
        return resp;
    }

    public URI fullPathKey(int server, String cache, String key, int offset) {
        StringBuilder queryBuilder = new StringBuilder(this.servers.get(server).getRestServerPath() + "/" + cache);
        if (key != null) {
            queryBuilder.append("/").append(key);
        }
        String query = queryBuilder.toString();
        String hostname = this.servers.get(server).getHostname();
        int connectionPort = this.port + offset;
        try {
            URL url = new URL(this.protocol, hostname, connectionPort, query);
            try {
                return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URI toSsl(URI uri) {
        try {
            return new URI(uri.toString().replaceFirst("http", "https"));
        }
        catch (URISyntaxException e) {
            throw new AssertionError("Not a valid URI", e);
        }
    }

    public URI fullPathKey(int server, String key) {
        return this.fullPathKey(server, this.cache, key, 0);
    }

    public URI fullPathKey(int server, String key, int portOffset) {
        return this.fullPathKey(server, this.cache, key, portOffset);
    }

    public URI fullPathKey(String cache, int server, String key, int portOffset) {
        return this.fullPathKey(server, cache, key, portOffset);
    }

    public URI fullPathKey(String key) {
        return this.fullPathKey(0, key);
    }

    public URI fullPathKey(String cache, String key) {
        return this.fullPathKey(0, cache, key, 0);
    }

    public URI fullPathKey(String cache, String key, int portOffset) {
        return this.fullPathKey(0, cache, key, portOffset);
    }

    public List<Server> getServers() {
        return this.servers;
    }

    private static String getHostName(RemoteInfinispanServer server) {
        RESTEndpoint endpoint = server.getRESTEndpoint();
        String inetHostName = endpoint.getInetAddress().getHostName();
        String realHostName = endpoint.getInetAddress() instanceof Inet6Address ? "[" + inetHostName + "]" : inetHostName;
        return realHostName;
    }

    public static class Server {
        private String hostname;
        private String restServerPath;

        public Server(String hostname, String restServerPath) {
            this.hostname = hostname;
            this.restServerPath = restServerPath;
        }

        public Server(RemoteInfinispanServer server) {
            this.hostname = RESTHelper.getHostName(server);
            this.restServerPath = server.getRESTEndpoint().getContextPath();
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getRestServerPath() {
            return this.restServerPath;
        }
    }
}

