/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.configs;

import java.io.File;
import java.util.ArrayList;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RemoteInfinispanServers;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.infinispan.server.test.client.rest.RESTHelper;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.server.test.util.RemoteCacheManagerFactory;
import org.infinispan.server.test.util.RemoteInfinispanMBeans;
import org.jboss.arquillian.container.test.api.Config;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ExampleConfigsIT {
    protected static final String KEYSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "keystore_client.jks";
    protected static final String TRUSTSTORE_PATH = ITestUtils.SERVER_CONFIG_DIR + File.separator + "ca.jks";
    protected static final String KEYSTORE_PASSWORD = "secret";
    private static final Logger log = Logger.getLogger(ExampleConfigsIT.class);
    @InfinispanResource
    RemoteInfinispanServers serverManager;
    static final String DEFAULT_CACHE_NAME = "default";
    static final String NAMED_CACHE_NAME = "namedCache";
    @ArquillianResource
    ContainerController controller;
    RemoteCacheManagerFactory rcmFactory;

    @Before
    public void setUp() {
        this.rcmFactory = new RemoteCacheManagerFactory();
    }

    @After
    public void tearDown() {
        if (this.rcmFactory != null) {
            this.rcmFactory.stopManagers();
        }
        this.rcmFactory = null;
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="example-hotrod-rolling-upgrade-2"), @RunningServer(name="example-hotrod-rolling-upgrade-1")})
    public void testHotRodRollingUpgrades() throws Exception {
        RemoteInfinispanMBeans s2 = this.createRemotes("example-hotrod-rolling-upgrade-2", "local", DEFAULT_CACHE_NAME);
        RemoteCache c2 = this.createCache(s2);
        c2.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)c2.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            c2.put((Object)("keyLoad" + i), (Object)("valueLoad" + i));
        }
        this.controller.start("example-hotrod-rolling-upgrade-1");
        RemoteInfinispanMBeans s1 = this.createRemotes("example-hotrod-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
        RemoteCache c1 = this.createCache(s1);
        Assert.assertEquals((String)"Can't access etries stored in source node (target's RemoteCacheStore).", (Object)"value1", (Object)c1.get((Object)"key1"));
        MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
        MBeanServerConnectionProvider provider2 = new MBeanServerConnectionProvider(s2.server.getHotrodEndpoint().getInetAddress().getHostName(), 10090);
        ObjectName rollMan = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
        ITestUtils.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"hotrod"}, new String[]{"java.lang.String"});
        c2.put((Object)"disconnected", (Object)"source");
        Assert.assertEquals((String)"Can't obtain value from cache1 (source node).", (Object)"source", (Object)c2.get((Object)"disconnected"));
        Assert.assertNull((String)"Source node entries should NOT be accessible from target node (after RCS disconnection)", (Object)c1.get((Object)"disconnected"));
        Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)"value1", (Object)c1.get((Object)"key1"));
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((String)"Entry was not successfully migrated.", (Object)("valueLoad" + i), (Object)c1.get((Object)("keyLoad" + i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    @WithRunningServer(value={@RunningServer(name="rest-rolling-upgrade-2"), @RunningServer(name="rest-rolling-upgrade-1")})
    public void testRestRollingUpgrades() throws Exception {
        int PORT_OFFSET = 100;
        RESTHelper rest = new RESTHelper();
        this.controller.start("rest-rolling-upgrade-2");
        try {
            RemoteInfinispanMBeans s2 = this.createRemotes("rest-rolling-upgrade-2", "local", DEFAULT_CACHE_NAME);
            rest.addServer(s2.server.getRESTEndpoint().getInetAddress().getHostName(), s2.server.getRESTEndpoint().getContextPath());
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data", "text/plain");
            rest.get(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "key1", 100), "data", 200, false, "Accept", "text/plain");
            for (int i = 0; i < 50; ++i) {
                rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "keyLoad" + i, 100), "valueLoad" + i, "text/plain");
            }
            this.controller.start("rest-rolling-upgrade-1");
            RemoteInfinispanMBeans s1 = this.createRemotes("rest-rolling-upgrade-1", "local", DEFAULT_CACHE_NAME);
            rest.addServer(s1.server.getRESTEndpoint().getInetAddress().getHostName(), s1.server.getRESTEndpoint().getContextPath());
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "key1", 0), "data", 200, false, "Accept", "text/plain");
            MBeanServerConnectionProvider provider1 = new MBeanServerConnectionProvider(s1.server.getRESTEndpoint().getInetAddress().getHostName(), 9990);
            ObjectName rollMan = new ObjectName("jboss.datagrid-infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=RollingUpgradeManager");
            ITestUtils.invokeOperation(provider1, rollMan.toString(), "synchronizeData", new Object[]{"rest"}, new String[]{"java.lang.String"});
            ITestUtils.invokeOperation(provider1, rollMan.toString(), "disconnectSource", new Object[]{"rest"}, new String[]{"java.lang.String"});
            rest.post(rest.fullPathKey(0, DEFAULT_CACHE_NAME, "disconnected", 100), "source", "text/plain");
            rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "disconnected", 0), 404);
            for (int i = 0; i < 50; ++i) {
                rest.get(rest.fullPathKey(1, DEFAULT_CACHE_NAME, "keyLoad" + i, 0), "valueLoad" + i);
            }
        }
        finally {
            if (this.controller.isStarted("rest-rolling-upgrade-1")) {
                this.controller.stop("rest-rolling-upgrade-1");
            }
            if (this.controller.isStarted("rest-rolling-upgrade-2")) {
                this.controller.stop("rest-rolling-upgrade-2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-endpoints-interoperability")})
    public void testEndpointInteroperability() throws Exception {
        MemcachedClient memcachedClient = null;
        CloseableHttpClient restClient = null;
        try {
            RemoteInfinispanMBeans s1 = this.createRemotes("standalone-endpoints-interoperability", "local", DEFAULT_CACHE_NAME);
            RemoteCache s1Cache = this.createCache(s1);
            restClient = HttpClients.createDefault();
            String restUrl = "http://" + s1.server.getHotrodEndpoint().getInetAddress().getHostName() + ":8080" + s1.server.getRESTEndpoint().getContextPath() + "/" + DEFAULT_CACHE_NAME;
            memcachedClient = new MemcachedClient(s1.server.getMemcachedEndpoint().getInetAddress().getHostName(), s1.server.getMemcachedEndpoint().getPort());
            String key = "1";
            Assert.assertNull((Object)s1Cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1"));
            Assert.assertEquals((Object)"v1", (Object)s1Cache.get((Object)key));
            HttpGet get = new HttpGet(restUrl + "/" + key);
            get.addHeader("Accept", ContentType.TEXT_PLAIN.toString());
            CloseableHttpResponse getResponse = restClient.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)getResponse.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"v1", (Object)EntityUtils.toString((HttpEntity)getResponse.getEntity()));
            Assert.assertEquals((Object)"v1", (Object)memcachedClient.get(key));
            key = "2";
            HttpPut put = new HttpPut(restUrl + "/" + key);
            put.setEntity((HttpEntity)new StringEntity("<hey>ho</hey>", ContentType.TEXT_PLAIN));
            CloseableHttpResponse putResponse = restClient.execute((HttpUriRequest)put);
            Assert.assertEquals((long)200L, (long)putResponse.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"<hey>ho</hey>", (Object)s1Cache.get((Object)key));
            Assert.assertEquals((Object)"<hey>ho</hey>", (Object)memcachedClient.get(key));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
            if (memcachedClient != null) {
                memcachedClient.close();
            }
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-fcs-local")})
    public void testFileCacheStoreConfig() throws Exception {
        this.doPutGetCheckPath(this.createRemotes("standalone-fcs-local", "local", DEFAULT_CACHE_NAME), "dc", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-fcs-local", "local", NAMED_CACHE_NAME), "nc", 2.1);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-jdbc")})
    public void testJDBCCacheStoreConfig() throws Exception {
        int i;
        RemoteInfinispanMBeans sDefault = this.createRemotes("clustered-jdbc", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans sNamed = this.createRemotes("clustered-jdbc", "clustered", NAMED_CACHE_NAME);
        RemoteCache sDefaultCache = this.createCache(sDefault);
        RemoteCache sNamedCache = this.createCache(sNamed);
        sNamedCache.put((Object)"key", (Object)"value");
        sNamedCache.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value", (Object)sNamedCache.get((Object)"key"));
        Assert.assertEquals((Object)"value2", (Object)sNamedCache.get((Object)"key2"));
        for (i = 0; i < 1001; ++i) {
            sDefaultCache.put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 1001; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)sDefaultCache.get((Object)("k" + i)));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rocksdb-cs-local")})
    public void testRocksDBCacheStoreConfig() throws Exception {
        this.doPutGetCheckPath(this.createRemotes("standalone-rocksdb-cs-local", "local", DEFAULT_CACHE_NAME), "rocksdb-dcdefault", -1.0);
        this.doPutGetCheckPath(this.createRemotes("standalone-rocksdb-cs-local", "local", NAMED_CACHE_NAME), "rocksdb-ncnamedCache", 2.1);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-hotrod-multiple")})
    public void testHotrodMultipleConfig() throws Exception {
        int i;
        RemoteInfinispanMBeans s = this.createRemotes("standalone-hotrod-multiple", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c1 = this.createCache(s, ITestUtils.createConfigBuilder(s.server.getHotrodEndpoint("external").getInetAddress().getHostName(), s.server.getHotrodEndpoint("external").getPort()));
        RemoteCache<Object, Object> c2 = this.createCache(s, ITestUtils.createConfigBuilder(s.server.getHotrodEndpoint("internal").getInetAddress().getHostName(), s.server.getHotrodEndpoint("internal").getPort()));
        Assert.assertEquals((long)0L, (long)s.cache.getNumberOfEntries());
        for (i = 0; i < 10; ++i) {
            c1.put((Object)("k" + i), (Object)("v" + i));
        }
        Assert.assertTrue((s.cache.getNumberOfEntries() <= 10L ? 1 : 0) != 0);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)c2.get((Object)("k" + i)));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rcs-local-2"), @RunningServer(name="standalone-rcs-local-1")})
    public void testRemoteCacheStoreConfig() throws Exception {
        RemoteInfinispanMBeans sRemoteStoreDefault = this.createRemotes("standalone-rcs-local-2", "local", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans sRemoteStoreNamed = this.createRemotes("standalone-rcs-local-2", "local", NAMED_CACHE_NAME);
        RemoteInfinispanMBeans s1Default = this.createRemotes("standalone-rcs-local-1", "local", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s1Named = this.createRemotes("standalone-rcs-local-1", "local", NAMED_CACHE_NAME);
        this.doPutGetRemove(s1Default, sRemoteStoreDefault);
        this.doPutGetWithExpiration(s1Named, sRemoteStoreNamed);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-hotrod-ssl")})
    public void testSSLHotRodConfig() throws Exception {
        RemoteInfinispanMBeans s = this.createRemotes("standalone-hotrod-ssl", "local", DEFAULT_CACHE_NAME);
        RemoteCache<Object, Object> c = this.createCache(s, this.securityConfig("keystore_client.jks", "ca.jks", s.server));
        this.doPutGet(s, c);
        try {
            this.doPutGet(s, this.createCache(s, this.securityConfig("keystore_server_no_ca.jks", "ca.jks", s.server)));
            Assert.fail((String)"Should have failed to write");
        }
        catch (TransportException transportException) {
            // empty catch block
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rest-ssl")})
    public void testRestSslConfig() throws Exception {
        RemoteInfinispanMBeans s = this.createRemotes("standalone-hotrod-ssl", "local", DEFAULT_CACHE_NAME);
        SSLContext sslContext = SslContextFactory.getContext((String)KEYSTORE_PATH, (char[])KEYSTORE_PASSWORD.toCharArray(), (String)TRUSTSTORE_PATH, (char[])KEYSTORE_PASSWORD.toCharArray());
        RESTHelper rest = new RESTHelper();
        rest.withSslContext(sslContext).withPort(8443).withProtocol("https").withServer(s.server);
        ExampleConfigsIT.cleanRESTServer(rest);
        HttpResponse response = rest.put(rest.fullPathKey(0, "a"), "data", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        rest.get(rest.fullPathKey(0, "a"), "data");
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.post(rest.fullPathKey(0, "a"), "data", "text/plain");
        rest.get(rest.fullPathKey(0, "a"), "data");
        ExampleConfigsIT.cleanRESTServer(rest);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-storage-only-1"), @RunningServer(name="clustered-storage-only-2")})
    public void testStorageOnlyConfig() throws Exception {
        RemoteInfinispanMBeans s1 = this.createRemotes("clustered-storage-only-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache s1Cache = this.createCache(s1);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        s1Cache.put((Object)"k", (Object)"v");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)s1Cache.get((Object)"k"), (Object)"v");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        s1Cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)3L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((Object)"v", (Object)s1Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v2", (Object)s1Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)s1Cache.get((Object)"k3"));
        try {
            ITestUtils.createCacheManager(this.serverManager.getServer("clustered-storage-only-2"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testTopologyConfigMachineAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s1", "r1", "m2");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    @Test
    public void testTopologyConfigRackAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r1", "m2");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s1", "r2", "m3");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    @Test
    public void testTopologyConfigSiteAttribute() throws Exception {
        try {
            this.startContainerWithTopology("clustered-topology-1", "node0", 0, "s1", "r1", "m1");
            this.startContainerWithTopology("clustered-topology-2", "node1", 100, "s1", "r2", "m2");
            this.startContainerWithTopology("clustered-topology-3", "node2", 200, "s2", "r3", "m3");
            this.verifyTopologyHinting("clustered-topology-1", "clustered-topology-2", "clustered-topology-3", "clustered", DEFAULT_CACHE_NAME);
        }
        catch (Throwable throwable) {
            ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
            throw throwable;
        }
        ITestUtils.stopContainers(this.controller, "clustered-topology-1", "clustered-topology-2", "clustered-topology-3");
    }

    private void verifyTopologyHinting(String container1, String container2, String container3, String manager, String cache) {
        RemoteInfinispanMBeans s1 = this.createRemotes(container1, manager, cache);
        RemoteInfinispanMBeans s2 = this.createRemotes(container2, manager, cache);
        RemoteInfinispanMBeans s3 = this.createRemotes(container3, manager, cache);
        RemoteCache s1Cache = this.createCache(s1);
        RemoteCache s2Cache = this.createCache(s2);
        RemoteCache s3Cache = this.createCache(s3);
        Assert.assertEquals((long)3L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)3L, (long)s2.manager.getClusterSize());
        Assert.assertEquals((long)3L, (long)s3.manager.getClusterSize());
        int total_elements = 0;
        s1Cache.clear();
        s2Cache.clear();
        s3Cache.clear();
        long s0Entries = 0L;
        long s1Entries = 0L;
        long s2Entries = 0L;
        ArrayList<String> s1Bulk = new ArrayList<String>();
        ArrayList<String> s2Bulk = new ArrayList<String>();
        while (s0Entries == 0L || s1Entries == 0L || s2Entries == 0L || total_elements < 5) {
            s1Cache.put((Object)("machine" + total_elements), (Object)"machine");
            if (s1Entries + 1L == s2.cache.getNumberOfEntries()) {
                s1Bulk.add("machine" + total_elements);
            }
            if (s2Entries + 1L == s3.cache.getNumberOfEntries()) {
                s2Bulk.add("machine" + total_elements);
            }
            s1Entries = s2.cache.getNumberOfEntries();
            s2Entries = s3.cache.getNumberOfEntries();
            s0Entries = s1.cache.getNumberOfEntries();
            if (++total_elements <= 10) continue;
        }
        Assert.assertTrue((String)("Unexpected number of entries in server1: " + s0Entries), (s0Entries > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Unexpected number of entries in server2: " + s1Entries), (s1Entries > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Instead of " + total_elements * 2 + " total elements there were " + (s0Entries + s1Entries + s2Entries)), (s0Entries + s1Entries + s2Entries == (long)(total_elements * 2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Server 1 elements are not contained in server 2", (boolean)s2Bulk.containsAll(s1Bulk));
        for (String key : s1Bulk) {
            s2Cache.remove((Object)key);
        }
        s0Entries = s1.cache.getNumberOfEntries();
        s1Entries = s2.cache.getNumberOfEntries();
        s2Entries = s3.cache.getNumberOfEntries();
        Assert.assertEquals((String)("There were " + s1Entries + " left in the 2nd server"), (long)0L, (long)s1Entries);
        Assert.assertEquals((long)s0Entries, (long)s2Entries);
        Assert.assertNotEquals((long)s0Entries, (long)s1Entries);
        Assert.assertEquals((Object)s1Cache.getBulk(), (Object)s3Cache.getBulk());
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-1"), @RunningServer(name="clustered-2")})
    public void testTwoNodesConfig() throws Exception {
        RemoteInfinispanMBeans s1 = this.createRemotes("clustered-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s2 = this.createRemotes("clustered-2", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache s1Cache = this.createCache(s1);
        RemoteCache s2Cache = this.createCache(s2);
        RESTHelper rest = new RESTHelper();
        rest = rest.withServers(s1.server, s2.server);
        ExampleConfigsIT.cleanRESTServer(rest);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
        ITestUtils.eventually(() -> s1.manager.getClusterSize() == 2, 30000L, 300);
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)2L, (long)s2.manager.getClusterSize());
        s1Cache.put((Object)"k", (Object)"v");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)s1Cache.get((Object)"k"), (Object)"v");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        s2Cache.put((Object)"k3", (Object)"v3");
        Assert.assertEquals((long)3L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((Object)"v", (Object)s1Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v", (Object)s2Cache.get((Object)"k"));
        Assert.assertEquals((Object)"v2", (Object)s1Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v2", (Object)s2Cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v3", (Object)s1Cache.get((Object)"k3"));
        Assert.assertEquals((Object)"v3", (Object)s2Cache.get((Object)"k3"));
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.put(rest.fullPathKey(0, "a"), "data", "text/plain");
        rest.get(rest.fullPathKey(1, "a"), "data");
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.post(rest.fullPathKey(0, "a"), "data", "text/plain");
        rest.get(rest.fullPathKey(1, "a"), "data");
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.post(rest.fullPathKey(0, "a"), "data", "text/plain");
        rest.get(rest.fullPathKey(1, "a"), "data");
        rest.delete(rest.fullPathKey(0, "a"));
        rest.head(rest.fullPathKey(1, "a"), 404);
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.post(rest.fullPathKey(0, "a"), "data", "text/plain");
        rest.post(rest.fullPathKey(0, "b"), "data", "text/plain");
        rest.head(rest.fullPathKey(0, "a"));
        rest.head(rest.fullPathKey(0, "b"));
        rest.delete(rest.fullPathKey(0, null));
        rest.head(rest.fullPathKey(1, "a"), 404);
        rest.head(rest.fullPathKey(1, "b"), 404);
        ExampleConfigsIT.cleanRESTServer(rest);
        rest.post(rest.fullPathKey(0, "a"), "data", "text/plain", 200, "Content-Type", "text/plain", "timeToLiveSeconds", "2");
        rest.head(rest.fullPathKey(1, "a"));
        ITestUtils.sleepForSecs(2.1);
        rest.head(rest.fullPathKey(1, "a"), 404);
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="clustered-xsite-1"), @RunningServer(name="clustered-xsite-2"), @RunningServer(name="clustered-xsite-3")})
    public void testXsiteConfig() throws Exception {
        RemoteInfinispanMBeans s1 = this.createRemotes("clustered-xsite-1", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s2 = this.createRemotes("clustered-xsite-2", "clustered", DEFAULT_CACHE_NAME);
        RemoteInfinispanMBeans s3 = this.createRemotes("clustered-xsite-3", "clustered", DEFAULT_CACHE_NAME);
        RemoteCache s1Cache = this.createCache(s1);
        RemoteCache s2Cache = this.createCache(s2);
        RemoteCache s3Cache = this.createCache(s3);
        Assert.assertEquals((long)0L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s1.manager.getClusterSize());
        Assert.assertEquals((long)2L, (long)s2.manager.getClusterSize());
        Assert.assertEquals((long)1L, (long)s3.manager.getClusterSize());
        s1Cache.put((Object)"k1", (Object)"v1");
        s1Cache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((long)2L, (long)s1.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s2.cache.getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)s3.cache.getNumberOfEntries());
        Assert.assertEquals((Object)s1Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s2Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s3Cache.get((Object)"k1"), (Object)"v1");
        Assert.assertEquals((Object)s1Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((Object)s2Cache.get((Object)"k2"), (Object)"v2");
        Assert.assertEquals((Object)s3Cache.get((Object)"k2"), (Object)"v2");
    }

    private static void cleanRESTServer(RESTHelper rest) throws Exception {
        rest.delete(rest.fullPathKey("a"));
        rest.delete(rest.fullPathKey("b"));
        rest.delete(rest.fullPathKey("c"));
        rest.head(rest.fullPathKey("a"), 404);
        rest.head(rest.fullPathKey("b"), 404);
        rest.head(rest.fullPathKey("c"), 404);
    }

    private ConfigurationBuilder securityConfig(String keystoreName, String truststoreName, RemoteInfinispanServer server) {
        ConfigurationBuilder builder = ITestUtils.createConfigBuilder(server.getHotrodEndpoint().getInetAddress().getHostName(), server.getHotrodEndpoint().getPort());
        builder.security().ssl().enable().keyStoreFileName(ITestUtils.SERVER_CONFIG_DIR + File.separator + keystoreName).keyStorePassword(KEYSTORE_PASSWORD.toCharArray()).trustStoreFileName(ITestUtils.SERVER_CONFIG_DIR + File.separator + truststoreName).trustStorePassword(KEYSTORE_PASSWORD.toCharArray()).maxRetries(3);
        return builder;
    }

    private void doPutGetRemove(RemoteInfinispanMBeans sMain, RemoteInfinispanMBeans sRemoteStore) {
        int i;
        Assert.assertEquals((long)0L, (long)sMain.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)sRemoteStore.cache.getNumberOfEntries());
        RemoteCache sMainCache = this.createCache(sMain);
        RemoteCache sRemoteStoreCache = this.createCache(sRemoteStore);
        for (i = 0; i < 1100; ++i) {
            sMainCache.put((Object)("key" + i), (Object)("value" + i));
        }
        Assert.assertTrue((sMain.cache.getNumberOfEntriesInMemory() <= 1000L ? 1 : 0) != 0);
        ITestUtils.eventually(() -> {
            log.debug((Object)("Num entries: Main cache: " + sMain.cache.getNumberOfEntries() + " Remote store: " + sRemoteStore.cache.getNumberOfEntriesInMemory() + " Total: " + (sMain.cache.getNumberOfEntriesInMemory() + sRemoteStore.cache.getNumberOfEntriesInMemory())));
            return sMain.cache.getNumberOfEntriesInMemory() + sRemoteStore.cache.getNumberOfEntriesInMemory() == 1100L;
        }, 10000L);
        for (i = 0; i < 1100; ++i) {
            Assert.assertNotNull((Object)sMainCache.get((Object)("key" + i)));
            sMainCache.remove((Object)("key" + i));
            Assert.assertNull((Object)sMainCache.get((Object)("key" + i)));
        }
        Assert.assertEquals((long)0L, (long)sMain.cache.getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)sRemoteStore.cache.getNumberOfEntries());
        sMainCache.clear();
        sRemoteStoreCache.clear();
    }

    private void doPutGetWithExpiration(RemoteInfinispanMBeans s1, RemoteInfinispanMBeans s2) {
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntriesInMemory());
        RemoteCache s1Cache = this.createCache(s1);
        this.doPutGet(s1, s1Cache);
        Assert.assertEquals((long)10L, (long)s2.cache.getNumberOfEntriesInMemory());
        ITestUtils.sleepForSecs(3.1);
        for (int i = 0; i < 10; ++i) {
            Assert.assertNull((Object)s1Cache.get((Object)("key" + i)));
        }
        Assert.assertEquals((long)0L, (long)s2.cache.getNumberOfEntriesInMemory());
    }

    private void doPutGet(RemoteInfinispanMBeans s, RemoteCache<Object, Object> c) {
        int i;
        Assert.assertEquals((long)0L, (long)s.cache.getNumberOfEntriesInMemory());
        for (i = 0; i < 10; ++i) {
            c.put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("v" + i), (Object)c.get((Object)("k" + i)));
        }
        Assert.assertEquals((long)10L, (long)s.cache.getNumberOfEntriesInMemory());
    }

    private void doPutGetCheckPath(RemoteInfinispanMBeans s, String filePath, double sleepTime) {
        RemoteCache sCache = this.createCache(s);
        this.doPutGet(s, sCache);
        if (sleepTime >= 0.0) {
            ITestUtils.sleepForSecs(sleepTime);
            for (int i = 0; i < 10; ++i) {
                Assert.assertNull((Object)sCache.get((Object)("k" + i)));
            }
        }
        File f = new File(ITestUtils.SERVER_DATA_DIR, filePath);
        Assert.assertTrue((boolean)f.isDirectory());
    }

    protected RemoteCache<Object, Object> createCache(RemoteInfinispanMBeans cacheBeans, ConfigurationBuilder configBuilder) {
        return this.rcmFactory.createCache(configBuilder, cacheBeans.cacheName);
    }

    protected <K, V> RemoteCache<K, V> createCache(RemoteInfinispanMBeans cacheBeans) {
        return this.rcmFactory.createCache(cacheBeans);
    }

    protected RemoteInfinispanMBeans createRemotes(String serverName, String managerName, String cacheName) {
        return RemoteInfinispanMBeans.create(this.serverManager, serverName, cacheName, managerName);
    }

    private void startContainerWithTopology(String containerName, String nodeName, int portOffset, String site, String rack, String machine) {
        this.controller.start(containerName, new Config().add("javaVmArguments", System.getProperty("server.jvm.args") + " -Djboss.node.name=" + nodeName + " -Djboss.socket.binding.port-offset=" + portOffset + " -Djboss.jgroups.topology.site=" + site + " -Djboss.jgroups.topology.rack=" + rack + " -Djboss.jgroups.topology.machine=" + machine).map());
    }
}

