/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.custom;

import java.io.File;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.persistence.cluster.MyCustomCacheStore;
import org.infinispan.persistence.spi.ExternalStore;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class CustomCacheStoreIT {
    private static File deployment;
    @InfinispanResource(value="standalone-customcs")
    RemoteInfinispanServer server;
    private static final int managementPort = 9990;
    private static final String cacheLoaderMBean = "jboss.datagrid-infinispan:type=Cache,name=\"default(local)\",manager=\"local\",component=CacheLoader";

    @BeforeClass
    public static void before() throws Exception {
        JavaArchive deployedCacheStore = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        deployedCacheStore.addPackage(MyCustomCacheStore.class.getPackage());
        deployedCacheStore.addAsServiceProvider(ExternalStore.class, new Class[]{MyCustomCacheStore.class});
        deployment = new File(System.getProperty("server1.dist"), "/standalone/deployments/custom-store.jar");
        ((ZipExporter)deployedCacheStore.as(ZipExporter.class)).exportTo(deployment, true);
    }

    @AfterClass
    public static void after() {
        if (deployment != null) {
            deployment.delete();
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-customcs")})
    public void testIfDeployedCacheContainsProperValues() throws Exception {
        RemoteCacheManager rcm = ITestUtils.createCacheManager(this.server);
        RemoteCache rc = rcm.getCache();
        Assert.assertNull((Object)rc.get((Object)"key1"));
        rc.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)rc.get((Object)"key1"));
        MBeanServerConnectionProvider provider = new MBeanServerConnectionProvider(this.server.getHotrodEndpoint().getInetAddress().getHostName(), 9990);
        Assert.assertEquals((Object)"[org.infinispan.persistence.cluster.MyCustomCacheStore]", (Object)this.getAttribute(provider, cacheLoaderMBean, "stores"));
    }

    private String getAttribute(MBeanServerConnectionProvider provider, String mbean, String attr) throws Exception {
        return provider.getConnection().getAttribute(new ObjectName(mbean), attr).toString();
    }
}

