/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.remote;

import java.util.Collection;
import java.util.HashSet;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.client.memcached.MemcachedClient;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
@WithRunningServer(value={@RunningServer(name="standalone-rcs-remote")})
public class RemoteCacheStoreIT {
    private final String CONTAINER_LOCAL = "standalone-rcs-local";
    private final String CONTAINER_REMOTE = "standalone-rcs-remote";
    public static final String LOCAL_CACHE_MANAGER = "local";
    private final String LOCAL_CACHE_NAME = "memcachedCache";
    private final String READONLY_CACHE_NAME = "readOnlyCache";
    private MemcachedClient mc;
    RemoteCache<Object, Object> cache;
    @InfinispanResource(value="standalone-rcs-local")
    RemoteInfinispanServer server1;
    @InfinispanResource(value="standalone-rcs-remote")
    RemoteInfinispanServer server2;
    @ArquillianResource
    ContainerController controller;
    RemoteCacheManager rcm1;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server2.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server2.getHotrodEndpoint().getPort()).build();
        this.cache = new RemoteCacheManager(conf).getCache();
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rcs-local")})
    public void testReadOnly() throws Exception {
        Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
        this.rcm1 = new RemoteCacheManager(conf);
        RemoteCache rc1 = this.rcm1.getCache("readOnlyCache");
        HashSet<String> allKeys = new HashSet<String>();
        for (int i = 1; i < 4; ++i) {
            String key = "k" + i;
            rc1.put((Object)key, (Object)("v" + i));
            allKeys.add(key);
        }
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntriesInMemory());
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("readOnlyCache").getNumberOfEntries());
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("readOnlyCache").getNumberOfEntriesInMemory());
        CloseableIteratorSet storedKeys = rc1.keySet();
        allKeys.removeAll((Collection<?>)storedKeys);
        for (String key : allKeys) {
            Assert.assertNull((Object)rc1.get((Object)key));
        }
        for (String key : storedKeys) {
            int i = Integer.parseInt(key.substring(1));
            Assert.assertEquals((Object)("v" + i), (Object)rc1.get((Object)key));
        }
    }

    @Test
    @WithRunningServer(value={@RunningServer(name="standalone-rcs-local")})
    public void testPassivateAfterEviction() throws Exception {
        this.mc = new MemcachedClient(this.server1.getMemcachedEndpoint().getInetAddress().getHostName(), this.server1.getMemcachedEndpoint().getPort());
        this.assertCleanCacheAndStore();
        this.mc.set("k1", "v1");
        this.mc.set("k2", "v2");
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
        this.mc.set("k3", "v3");
        Assert.assertEquals((long)2L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("memcachedCache").getNumberOfEntriesInMemory());
        Assert.assertEquals((long)1L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntriesInMemory());
        Assert.assertEquals((Object)"v1", (Object)this.mc.get("k1"));
        Assert.assertEquals((Object)"v2", (Object)this.mc.get("k2"));
        Assert.assertEquals((Object)"v3", (Object)this.mc.get("k3"));
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
    }

    private void assertCleanCacheAndStore() throws Exception {
        this.mc.delete("k1");
        this.mc.delete("k2");
        this.mc.delete("k3");
        this.cache.clear();
        Assert.assertEquals((long)0L, (long)this.server1.getCacheManager(LOCAL_CACHE_MANAGER).getCache("memcachedCache").getNumberOfEntries());
        Assert.assertEquals((long)0L, (long)this.server2.getCacheManager(LOCAL_CACHE_MANAGER).getDefaultCache().getNumberOfEntries());
    }
}

