/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.cs.rocksdb;

import java.io.File;
import org.apache.commons.codec.binary.Hex;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.model.RemoteInfinispanCache;
import org.infinispan.arquillian.model.RemoteInfinispanCacheManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.category.CacheStore;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

@RunWith(value=Arquillian.class)
@Category(value={CacheStore.class})
public class RocksDBCacheStoreIT {
    private static final Log log = LogFactory.getLog(RocksDBCacheStoreIT.class);
    @InfinispanResource(value="rocksdb")
    RemoteInfinispanServer server;
    @ArquillianResource
    ContainerController controller;
    public static final String CONTAINER = "rocksdb";
    private static File dataDir = new File(ITestUtils.SERVER_DATA_DIR + File.separator + "rocksdbtestcache");
    private static File expiredDir = new File(ITestUtils.SERVER_DATA_DIR + File.separator + "rocksdb-expiredtestcache");
    private final TestMarshaller clientMarshaller = new TestMarshaller();

    @Before
    @After
    public void removeDataFilesIfExists() {
        Util.recursiveFileRemove((File)dataDir);
        Util.recursiveFileRemove((File)expiredDir);
    }

    @Test
    public void testDataSurvivesRestart() {
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        cache.put((Object)"key2", (Object)"2");
        cache.put((Object)"key3", (Object)"3");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        log.tracef("Stored via Hot Rod:", new Object[0]);
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        this.controller.start(CONTAINER);
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        Assert.assertEquals((Object)"2", (Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"3", (Object)cache.get((Object)"key3"));
        this.controller.stop(CONTAINER);
    }

    @Test
    public void testDataRetrievableViaRocksDbApi() throws Exception {
        this.controller.start(CONTAINER);
        RemoteInfinispanCacheManager managerJmx = this.server.getCacheManager("local");
        RemoteInfinispanCache cacheJmx = managerJmx.getCache("testcache");
        RemoteCache cache = this.createManager().getCache();
        cache.clear();
        Assert.assertEquals((long)0L, (long)cacheJmx.getNumberOfEntries());
        cache.put((Object)"key1", (Object)"1");
        Assert.assertEquals((Object)"1", (Object)cache.get((Object)"key1"));
        System.out.println("Stored via Hot Rod:");
        Assert.assertTrue((boolean)dataDir.exists());
        Assert.assertTrue((boolean)dataDir.isDirectory());
        Assert.assertTrue((boolean)expiredDir.exists());
        Assert.assertTrue((boolean)expiredDir.isDirectory());
        this.controller.stop(CONTAINER);
        RocksDB db = RocksDB.open((Options)new Options(), (String)dataDir.getAbsolutePath());
        log.tracef("RocksDB file " + dataDir.getAbsolutePath() + " contents:", new Object[0]);
        RocksIterator i = db.newIterator();
        while (i.isValid()) {
            log.tracef("key \"" + Hex.encodeHexString((byte[])i.key()) + "\": value \"" + Hex.encodeHexString((byte[])i.value()) + "\"", new Object[0]);
            Assert.assertNotNull((Object)i.value());
            i.next();
        }
    }

    private RemoteCacheManager createManager() {
        ConfigurationBuilder cfgBuild = ITestUtils.createConfigBuilder(this.server.getHotrodEndpoint().getInetAddress().getHostName(), this.server.getHotrodEndpoint().getPort());
        cfgBuild.marshaller((Marshaller)this.clientMarshaller);
        return new RemoteCacheManager(cfgBuild.build());
    }

    private static class TestMarshaller
    extends AbstractMarshaller {
        private TestMarshaller() {
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
            byte[] bytes = new byte[length];
            System.arraycopy(buf, offset, bytes, 0, length);
            return new String(bytes);
        }

        public boolean isMarshallable(Object o) {
            return o instanceof String;
        }

        public MediaType mediaType() {
            return MediaType.APPLICATION_OCTET_STREAM;
        }

        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) {
            if (o instanceof String) {
                String str = (String)o;
                byte[] bytes = str.getBytes();
                return new ByteBufferImpl(bytes, 0, bytes.length);
            }
            throw new IllegalArgumentException("type not marshallable");
        }
    }
}

