/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.eviction;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.util.ITestUtils;
import org.infinispan.test.TestingUtil;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="eviction")})
public class EvictionIT {
    @InfinispanResource(value="eviction")
    RemoteInfinispanServer server1;
    private static RemoteCacheManager remoteCacheManager;

    @Before
    public void setUp() {
        if (remoteCacheManager == null) {
            remoteCacheManager = ITestUtils.createCacheManager(this.server1);
        }
    }

    @Test
    public void testPutAllEviction() {
        RemoteCache rc = remoteCacheManager.getCache("object");
        rc.clear();
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("keyA", "A");
        entries.put("keyB", "B");
        entries.put("keyC", "C");
        entries.put("keyD", "D");
        rc.putAll(entries);
        Assert.assertEquals((long)3L, (long)rc.size());
    }

    @Test
    public void testPutAllAsyncEviction() {
        RemoteCache rc = remoteCacheManager.getCache("binary");
        rc.clear();
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("keyA", "A");
        entries.put("keyB", "B");
        entries.put("keyC", "C");
        entries.put("keyD", "D");
        CompletableFuture res = rc.putAllAsync(entries);
        res.thenRun(() -> Assert.assertEquals((long)3L, (long)rc.size()));
    }

    @Test
    public void testMultipleClients() {
        RemoteCache rc1 = remoteCacheManager.getCache("off-heap");
        RemoteCache rc2 = remoteCacheManager.getCache("off-heap");
        rc1.clear();
        for (int i = 0; i < 1000; ++i) {
            rc1.put((Object)String.format("key1_%d", i), (Object)String.format("value1_%d", i));
            rc2.put((Object)String.format("key2_%d", i), (Object)String.format("value2_%d", i));
        }
        Assert.assertEquals((long)3L, (long)rc1.size());
        Assert.assertEquals((long)3L, (long)rc2.size());
    }

    @Test
    public void testEvictionInScript() throws IOException {
        this.addScripts("test.js");
        RemoteCache rc = remoteCacheManager.getCache("object");
        rc.clear();
        rc.put((Object)"keyA", (Object)"A");
        rc.put((Object)"keyB", (Object)"B");
        rc.put((Object)"keyC", (Object)"C");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", "keyD");
        parameters.put("value", "D");
        int result = (Integer)rc.execute("test.js", parameters);
        Assert.assertEquals((long)3L, (long)result);
        Assert.assertEquals((Object)"D", (Object)rc.get((Object)"keyD"));
    }

    private void addScripts(String script) throws IOException {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
            scriptCache.put((Object)script, (Object)TestingUtil.loadFileAsString((InputStream)in));
        }
    }
}

