/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.eviction;

import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.server.test.util.ITestUtils;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="eviction")})
public class EvictionStorageIT {
    @InfinispanResource(value="eviction")
    RemoteInfinispanServer server1;
    private static RemoteCacheManager remoteCacheManager;

    @Before
    public void setUp() {
        if (remoteCacheManager == null) {
            remoteCacheManager = ITestUtils.createCacheManager(this.server1);
        }
    }

    @Test
    public void testEvictionNone() {
        RemoteCache rc = remoteCacheManager.getCache("none");
        rc.clear();
        this.storeKeys((RemoteCache<String, String>)rc, "A", "B", "C");
        rc.put((Object)"keyD", (Object)"D");
        Assert.assertEquals((long)4L, (long)rc.size());
        Assert.assertEquals((Object)"A", (Object)rc.get((Object)"keyA"));
        Assert.assertEquals((Object)"B", (Object)rc.get((Object)"keyB"));
        Assert.assertEquals((Object)"C", (Object)rc.get((Object)"keyC"));
        Assert.assertEquals((Object)"D", (Object)rc.get((Object)"keyD"));
    }

    @Test
    public void testBinaryStorage() {
        this.testEviction("binary");
    }

    @Test
    public void testObjectStorage() {
        this.testEviction("object");
    }

    @Test
    public void testOffHeapStorage() {
        this.testEviction("off-heap");
    }

    private void testEviction(String cacheName) {
        RemoteCache rc = remoteCacheManager.getCache(cacheName);
        rc.clear();
        this.storeKeys((RemoteCache<String, String>)rc, "A", "B", "C");
        Assert.assertTrue((boolean)"B".equals(rc.get((Object)"keyB")));
        Assert.assertTrue((boolean)"A".equals(rc.get((Object)"keyA")));
        rc.put((Object)"keyD", (Object)"D");
        Assert.assertEquals((long)3L, (long)rc.size());
        Assert.assertEquals((Object)"D", (Object)rc.get((Object)"keyD"));
    }

    private void storeKeys(RemoteCache<String, String> rc, String ... values) {
        for (String value : values) {
            rc.put((Object)("key" + value), (Object)value);
        }
    }
}

