/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.jcache;

import java.lang.management.ManagementFactory;
import java.util.stream.StreamSupport;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.core.RunningServer;
import org.infinispan.arquillian.core.WithRunningServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@WithRunningServer(value={@RunningServer(name="cachecontainer")})
public class JCacheStateAwarenessIT {
    private static final String enableStatisticsTestCacheName = "enableStatisticsTestCache";
    private static final String enableManagementTestCacheName = "enableManagementTestCache";
    private static final String getCacheNamesTestCacheName = "getCacheNamesTestCache";
    private static final String getCacheTestCacheName = "getCacheTestCache";
    private static final String testKey = "testKey";
    private static final String testValue = "testValue";
    private static final String cachingProvider = "org.infinispan.jcache.remote.JCachingProvider";
    final int managementPort = 9999;
    @InfinispanResource(value="cachecontainer")
    private RemoteInfinispanServer server1;
    private RemoteCacheManager rcm1;
    private CachingProvider jcacheProvider;
    private CacheManager cacheManager;
    private MBeanServer mBeanServer;

    @Before
    public void setUp() {
        if (this.rcm1 == null) {
            Configuration conf = new ConfigurationBuilder().addServer().host(this.server1.getHotrodEndpoint().getInetAddress().getHostName()).port(this.server1.getHotrodEndpoint().getPort()).build();
            this.rcm1 = new RemoteCacheManager(conf);
            this.jcacheProvider = Caching.getCachingProvider((String)cachingProvider);
            this.cacheManager = this.jcacheProvider.getCacheManager();
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
    }

    @Test
    @Ignore(value="Ignored until ISPN-7095")
    public void testEnableStatistics() throws Exception {
        ObjectName mBeanName = this.getMBeanName(enableStatisticsTestCacheName, "Statistics");
        this.cacheManager.enableStatistics(enableStatisticsTestCacheName, true);
        Assert.assertTrue((String)"Statistics register as disabled after enabling", (boolean)this.mBeanServer.isRegistered(mBeanName));
        this.cacheManager.enableStatistics(enableStatisticsTestCacheName, false);
        Assert.assertFalse((String)"Statistics register as enabled after disabling", (boolean)this.mBeanServer.isRegistered(mBeanName));
    }

    @Test
    @Ignore(value="Ignored until ISPN-7095")
    public void testEnableManagement() throws MalformedObjectNameException {
        ObjectName mBeanName = this.getMBeanName(enableManagementTestCacheName, "Configuration");
        this.cacheManager.enableManagement(enableManagementTestCacheName, true);
        Assert.assertTrue((String)"Statistics register as disabled after enabling", (boolean)this.mBeanServer.isRegistered(mBeanName));
        this.cacheManager.enableManagement(enableManagementTestCacheName, false);
        Assert.assertFalse((String)"Statistics register as enabled after disabling", (boolean)this.mBeanServer.isRegistered(mBeanName));
    }

    private ObjectName getMBeanName(String testCacheName, String objectNameType) throws MalformedObjectNameException {
        return new ObjectName("javax.cache:type=Cache" + objectNameType + ",CacheManager=" + this.cacheManager.getURI().toString() + ",Cache=" + testCacheName);
    }

    @Test
    @Ignore(value="Ignored until ISPN-7095")
    public void testGetCacheNames() {
        boolean passed = StreamSupport.stream(this.cacheManager.getCacheNames().spliterator(), true).anyMatch(n -> getCacheNamesTestCacheName.equalsIgnoreCase((String)n));
        Assert.assertTrue((String)"getCacheNamesTestCache cache name was not found in list retrieved from CacheManager", (boolean)passed);
    }

    @Test
    public void testCacheGet(String testCacheName) {
        String cacheName = testCacheName != null ? testCacheName : getCacheTestCacheName;
        RemoteCache remoteCacheFromHR = this.rcm1.getCache(cacheName);
        Assert.assertNotNull((String)("The cache " + cacheName + " is not accessible trough HR (e.g. does not exist or is not there)"), (Object)remoteCacheFromHR);
        remoteCacheFromHR.put((Object)testKey, (Object)testValue);
        Cache remoteCacheFromJCache = this.cacheManager.getCache(cacheName);
        Assert.assertNotNull((String)("The cache " + cacheName + " is not accessible trough JCache"), (Object)remoteCacheFromJCache);
        Assert.assertNotNull((String)("Cache " + cacheName + " was retrieved, but key " + testKey + " could not be retrieved"), (Object)remoteCacheFromJCache.get((Object)testKey));
        Assert.assertEquals((String)"The cache was retrieved but the retrieved value was not same", (Object)remoteCacheFromJCache.get((Object)testKey), (Object)testValue);
    }
}

