/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.query;

import java.util.List;
import javax.management.ObjectName;
import org.infinispan.arquillian.core.InfinispanResource;
import org.infinispan.arquillian.core.RemoteInfinispanServer;
import org.infinispan.arquillian.utils.MBeanServerConnectionProvider;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.server.test.category.Queries;
import org.infinispan.server.test.query.RemoteQueryBaseIT;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={Queries.class})
@RunWith(value=Arquillian.class)
public class ManualIndexingIT
extends RemoteQueryBaseIT {
    @InfinispanResource(value="remote-query-1")
    protected RemoteInfinispanServer server;
    private MBeanServerConnectionProvider jmxConnectionProvider;

    public ManualIndexingIT() {
        super("clustered", "localtestcache_manual");
    }

    @Override
    public RemoteInfinispanServer getServer() {
        return this.server;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.jmxConnectionProvider = new MBeanServerConnectionProvider(this.getServer().getHotrodEndpoint().getInetAddress().getHostName(), 9990);
    }

    @Test
    public void testManualIndexing() throws Exception {
        QueryBuilder qb = Search.getQueryFactory((RemoteCache)this.remoteCache).from(User.class).having("name").eq((Object)"Tom");
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        this.remoteCache.put((Object)1, (Object)user);
        Assert.assertEquals((long)0L, (long)qb.build().list().size());
        ObjectName massIndexerName = new ObjectName("jboss.datagrid-infinispan:type=Query,manager=" + ObjectName.quote(this.cacheContainerName) + ",cache=" + ObjectName.quote(this.cacheName) + ",component=MassIndexer");
        this.jmxConnectionProvider.getConnection().invoke(massIndexerName, "start", null, null);
        List list = qb.build().list();
        Assert.assertEquals((long)1L, (long)list.size());
        User foundUser = (User)list.get(0);
        Assert.assertEquals((long)1L, (long)foundUser.getId());
        Assert.assertEquals((Object)"Tom", (Object)foundUser.getName());
        Assert.assertEquals((Object)"Cat", (Object)foundUser.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)foundUser.getGender());
    }
}

